/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.usage.service;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.lighthouse.usage.service.UserReference;
import com.atlassian.lighthouse.usage.service.UserReferenceProvider;
import com.atlassian.sal.api.user.UserKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/lighthouse/usage/service/JiraUserReferenceProvider;", "Lcom/atlassian/lighthouse/usage/service/UserReferenceProvider;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "(Lcom/atlassian/jira/user/util/UserManager;)V", "getUser", "Lcom/atlassian/lighthouse/usage/service/UserReference;", "key", "Lcom/atlassian/sal/api/user/UserKey;", "atlassian-lighthouse-core"})
public final class JiraUserReferenceProvider
implements UserReferenceProvider {
    @NotNull
    private final UserManager userManager;

    public JiraUserReferenceProvider(@NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        this.userManager = userManager;
    }

    @Override
    @NotNull
    public UserReference getUser(@NotNull UserKey key) {
        Intrinsics.checkNotNullParameter(key, "key");
        ApplicationUser jiraUser = this.userManager.getUserByKey(key.getStringValue());
        Object object = jiraUser;
        if (object == null || (object = object.getId()) == null || (object = String.valueOf(object)) == null) {
            String string = key.getStringValue();
            object = string;
            Intrinsics.checkNotNullExpressionValue(string, "getStringValue(...)");
        }
        return new UserReference(key, (String)object);
    }
}

