/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.usage.service;

import com.atlassian.audit.api.AuditRetentionConfigService;
import com.atlassian.lighthouse.database.dao.CachingUserAlertStatusCountsManager;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import com.atlassian.lighthouse.usage.CollatedUserSystemUsage;
import com.atlassian.lighthouse.usage.MonthUsage;
import com.atlassian.lighthouse.usage.UsageInfo;
import com.atlassian.lighthouse.usage.service.CachingAuditUsageService;
import com.atlassian.lighthouse.usage.service.UserReference;
import com.atlassian.lighthouse.usage.service.UserReferenceProvider;
import com.atlassian.lighthouse.usage.service.UserUsageStatisticsService;
import com.atlassian.lighthouse.usage.service.YearMonth;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.Month;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BK\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0018\u001a\u00020\u0019H\u0016JR\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u001a\u0010\u001d\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001e0\u001b2&\u0010!\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u001f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020 \u0018\u00010\"0\u001e0\u001bH\u0002J\b\u0010$\u001a\u00020\u0019H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020'H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001fH\u0002J$\u00103\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020 0\"2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001fH\u0002J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u000208H\u0002Jv\u00109\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H;\u0012\u0006\u0012\u0004\u0018\u0001H<0\u001e0\u001b0:\"\u0004\b\u0000\u0010;\"\u0004\b\u0001\u0010<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H;0\u001b2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u0002H;\u0012\u0004\u0012\u0002H<0?2$\u0010@\u001a \u0012\u0004\u0012\u0002H;\u0012\u0006\u0012\u0004\u0018\u0001H<\u0012\u0006\u0012\u0004\u0018\u00010B\u0012\u0006\u0012\u0004\u0018\u0001H<0AH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/atlassian/lighthouse/usage/service/UserUsageStatisticsServiceImpl;", "Lcom/atlassian/lighthouse/usage/service/UserUsageStatisticsService;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "auditRetentionConfigService", "Lcom/atlassian/audit/api/AuditRetentionConfigService;", "cachingAuditUsageService", "Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService;", "threadLocalDelegateExecutorFactory", "Lcom/atlassian/sal/api/executor/ThreadLocalDelegateExecutorFactory;", "timeSupplier", "Ljava/util/function/Supplier;", "Ljava/time/Instant;", "timezoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "cachingUserAlertStatusCountsManager", "Lcom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "userReferenceProvider", "Lcom/atlassian/lighthouse/usage/service/UserReferenceProvider;", "(Lcom/atlassian/audit/api/AuditRetentionConfigService;Lcom/atlassian/lighthouse/usage/service/CachingAuditUsageService;Lcom/atlassian/sal/api/executor/ThreadLocalDelegateExecutorFactory;Ljava/util/function/Supplier;Lcom/atlassian/sal/api/timezone/TimeZoneManager;Lcom/atlassian/lighthouse/database/dao/CachingUserAlertStatusCountsManager;Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/lighthouse/usage/service/UserReferenceProvider;)V", "authContextRetainingExecutorService", "Ljava/util/concurrent/ExecutorService;", "afterPropertiesSet", "", "collateUsage", "", "Lcom/atlassian/lighthouse/usage/MonthUsage;", "auditUsage", "Lkotlin/Pair;", "Lcom/atlassian/lighthouse/usage/service/YearMonth;", "", "securityAlertCounts", "", "Lcom/atlassian/lighthouse/security/detector/AlertStatus;", "destroy", "getPresentedMonths", "timezone", "Ljava/time/ZoneId;", "isSysAdmin", "", "getSystemTimezone", "getSystemUsage", "Lcom/atlassian/lighthouse/usage/CollatedUserSystemUsage;", "userKey", "Lcom/atlassian/sal/api/user/UserKey;", "getUserMonthAuditUsage", "user", "Lcom/atlassian/lighthouse/usage/service/UserReference;", "yearMonth", "getUserMonthSecurityAlertCounts", "monthIndex", "", "currentYear", "currentMonth", "Ljava/time/Month;", "runAllTasksAsync", "Ljava/util/concurrent/CompletableFuture;", "T", "R", "inputs", "task", "Lkotlin/Function1;", "handle", "Lkotlin/Function3;", "", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nUserUsageStatisticsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserUsageStatisticsService.kt\ncom/atlassian/lighthouse/usage/service/UserUsageStatisticsServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,224:1\n1549#2:225\n1620#2,3:226\n1549#2:229\n1620#2,3:230\n1549#2:233\n1620#2,3:234\n1549#2:239\n1620#2,3:240\n1549#2:243\n1620#2,3:244\n37#3,2:237\n*S KotlinDebug\n*F\n+ 1 UserUsageStatisticsService.kt\ncom/atlassian/lighthouse/usage/service/UserUsageStatisticsServiceImpl\n*L\n89#1:225\n89#1:226,3\n130#1:229\n130#1:230,3\n132#1:233\n132#1:234,3\n142#1:239\n142#1:240,3\n174#1:243\n174#1:244,3\n133#1:237,2\n*E\n"})
public class UserUsageStatisticsServiceImpl
implements UserUsageStatisticsService,
InitializingBean,
DisposableBean {
    @NotNull
    private final AuditRetentionConfigService auditRetentionConfigService;
    @NotNull
    private final CachingAuditUsageService cachingAuditUsageService;
    @NotNull
    private final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    @NotNull
    private final Supplier<Instant> timeSupplier;
    @NotNull
    private final TimeZoneManager timezoneManager;
    @NotNull
    private final CachingUserAlertStatusCountsManager cachingUserAlertStatusCountsManager;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final UserReferenceProvider userReferenceProvider;
    private ExecutorService authContextRetainingExecutorService;

    public UserUsageStatisticsServiceImpl(@NotNull AuditRetentionConfigService auditRetentionConfigService, @NotNull CachingAuditUsageService cachingAuditUsageService, @NotNull ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, @NotNull Supplier<Instant> timeSupplier, @NotNull TimeZoneManager timezoneManager, @NotNull CachingUserAlertStatusCountsManager cachingUserAlertStatusCountsManager, @NotNull UserManager userManager, @NotNull UserReferenceProvider userReferenceProvider) {
        Intrinsics.checkNotNullParameter(auditRetentionConfigService, "auditRetentionConfigService");
        Intrinsics.checkNotNullParameter(cachingAuditUsageService, "cachingAuditUsageService");
        Intrinsics.checkNotNullParameter(threadLocalDelegateExecutorFactory, "threadLocalDelegateExecutorFactory");
        Intrinsics.checkNotNullParameter(timeSupplier, "timeSupplier");
        Intrinsics.checkNotNullParameter(timezoneManager, "timezoneManager");
        Intrinsics.checkNotNullParameter(cachingUserAlertStatusCountsManager, "cachingUserAlertStatusCountsManager");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(userReferenceProvider, "userReferenceProvider");
        this.auditRetentionConfigService = auditRetentionConfigService;
        this.cachingAuditUsageService = cachingAuditUsageService;
        this.threadLocalDelegateExecutorFactory = threadLocalDelegateExecutorFactory;
        this.timeSupplier = timeSupplier;
        this.timezoneManager = timezoneManager;
        this.cachingUserAlertStatusCountsManager = cachingUserAlertStatusCountsManager;
        this.userManager = userManager;
        this.userReferenceProvider = userReferenceProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CollatedUserSystemUsage getSystemUsage(@NotNull UserKey userKey) {
        CompletableFuture completableFuture;
        boolean isSysAdmin;
        Intrinsics.checkNotNullParameter(userKey, "userKey");
        ZoneId timezone = this.getSystemTimezone();
        UserReference user = this.userReferenceProvider.getUser(userKey);
        boolean shouldProvideAuditUsageData = isSysAdmin = this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey());
        List<YearMonth> monthsToFetchDataFor = this.getPresentedMonths(timezone, isSysAdmin);
        if (shouldProvideAuditUsageData) {
            completableFuture = this.runAllTasksAsync(monthsToFetchDataFor, (Function1)new Function1<YearMonth, Long>(this, user){
                final /* synthetic */ UserUsageStatisticsServiceImpl this$0;
                final /* synthetic */ UserReference $user;
                {
                    this.this$0 = $receiver;
                    this.$user = $user;
                    super(1);
                }

                @NotNull
                public final Long invoke(@NotNull YearMonth it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return UserUsageStatisticsServiceImpl.access$getUserMonthAuditUsage(this.this$0, this.$user, it);
                }
            }, (Function3)new Function3<YearMonth, Long, Throwable, Long>(userKey){
                final /* synthetic */ UserKey $userKey;
                {
                    this.$userKey = $userKey;
                    super(3);
                }

                @Nullable
                public final Long invoke(@NotNull YearMonth monthYear, @Nullable Long usage, @Nullable Throwable error) {
                    Long l;
                    Intrinsics.checkNotNullParameter(monthYear, "monthYear");
                    if (error == null) {
                        l = usage;
                    } else {
                        boolean $i$f$getLogger = false;
                        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
                        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
                        logger.error("Failed to retrieve audit usage information for user (" + this.$userKey + ") for " + monthYear, error);
                        l = null;
                    }
                    return l;
                }
            });
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = monthsToFetchDataFor;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                YearMonth yearMonth = (YearMonth)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pair<void, Object>(it, null));
            }
            completableFuture = CompletableFuture.completedFuture((List)destination$iv$iv);
        }
        CompletableFuture auditUsageFuture2 = completableFuture;
        CompletableFuture securityAlertCountFuture2 = this.runAllTasksAsync(monthsToFetchDataFor, (Function1)new Function1<YearMonth, Map<AlertStatus, ? extends Long>>(this, user){
            final /* synthetic */ UserUsageStatisticsServiceImpl this$0;
            final /* synthetic */ UserReference $user;
            {
                this.this$0 = $receiver;
                this.$user = $user;
                super(1);
            }

            @NotNull
            public final Map<AlertStatus, Long> invoke(@NotNull YearMonth it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return UserUsageStatisticsServiceImpl.access$getUserMonthSecurityAlertCounts(this.this$0, this.$user, it);
            }
        }, (Function3)new Function3<YearMonth, Map<AlertStatus, ? extends Long>, Throwable, Map<AlertStatus, ? extends Long>>(userKey){
            final /* synthetic */ UserKey $userKey;
            {
                this.$userKey = $userKey;
                super(3);
            }

            @Nullable
            public final Map<AlertStatus, Long> invoke(@NotNull YearMonth monthYear, @Nullable Map<AlertStatus, Long> usage, @Nullable Throwable error) {
                Map<AlertStatus, Long> map;
                Intrinsics.checkNotNullParameter(monthYear, "monthYear");
                if (error == null) {
                    map = usage;
                } else {
                    boolean $i$f$getLogger = false;
                    Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
                    Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
                    logger.error("Failed to retrieve security alert counts for user (" + this.$userKey + ") for " + monthYear, error);
                    map = null;
                }
                return map;
            }
        });
        List<Pair<YearMonth, Long>> auditUsage = auditUsageFuture2.get();
        List securityAlertCounts = securityAlertCountFuture2.get();
        Intrinsics.checkNotNull(auditUsage);
        Intrinsics.checkNotNull(securityAlertCounts);
        return new CollatedUserSystemUsage(shouldProvideAuditUsageData, this.collateUsage(auditUsage, securityAlertCounts));
    }

    /*
     * WARNING - void declaration
     */
    private final <T, R> CompletableFuture<List<Pair<T, R>>> runAllTasksAsync(List<? extends T> inputs, Function1<? super T, ? extends R> task, Function3<? super T, ? super R, ? super Throwable, ? extends R> handle) {
        Collection collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = inputs;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void input;
            object = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Supplier<Object> supplier = () -> UserUsageStatisticsServiceImpl.runAllTasksAsync$lambda$2$lambda$1(task, input);
            ExecutorService executorService = this.authContextRetainingExecutorService;
            if (executorService == null) {
                Intrinsics.throwUninitializedPropertyAccessException("authContextRetainingExecutorService");
                executorService = null;
            }
            collection.add(CompletableFuture.supplyAsync(supplier, executorService));
        }
        $this$map$iv = CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Iterable)inputs);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CompletableFuture future = (CompletableFuture)((Pair)object).component1();
            Object input = ((Pair)object).component2();
            collection.add(future.handle((arg_0, arg_1) -> UserUsageStatisticsServiceImpl.runAllTasksAsync$lambda$4$lambda$3(new Function2<R, Throwable, Pair<? extends T, ? extends R>>(input, handle){
                final /* synthetic */ T $input;
                final /* synthetic */ Function3<T, R, Throwable, R> $handle;
                {
                    this.$input = $input;
                    this.$handle = $handle;
                    super(2);
                }

                public final Pair<T, R> invoke(R usage, @Nullable Throwable throwable) {
                    return new Pair<T, R>(this.$input, this.$handle.invoke(this.$input, usage, throwable));
                }
            }, arg_0, arg_1)));
        }
        List futures2 = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = futures2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletionStage completionStage = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenApply(arg_0 -> UserUsageStatisticsServiceImpl.runAllTasksAsync$lambda$5(new Function1<Void, List<? extends Pair<? extends T, ? extends R>>>(futures2){
            final /* synthetic */ List<CompletableFuture<Pair<T, R>>> $futures;
            {
                this.$futures = $futures;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<Pair<T, R>> invoke(Void it) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$futures;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    CompletableFuture completableFuture = (CompletableFuture)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((Pair)it2.get());
                }
                return (List)destination$iv$iv;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MonthUsage> collateUsage(List<Pair<YearMonth, Long>> auditUsage, List<? extends Pair<YearMonth, ? extends Map<AlertStatus, Long>>> securityAlertCounts) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)auditUsage, (Iterable)securityAlertCounts);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair audit = (Pair)pair.component1();
            Pair alerts = (Pair)pair.component2();
            YearMonth yearMonth = (YearMonth)audit.getFirst();
            Month month = yearMonth.component1();
            int year = yearMonth.component2();
            collection.add(new MonthUsage(month, year, new UsageInfo((Long)audit.getSecond(), (Map)alerts.getSecond())));
        }
        return (List)destination$iv$iv;
    }

    private final ZoneId getSystemTimezone() {
        ZoneId zoneId = this.timezoneManager.getDefaultTimeZone().toZoneId();
        Intrinsics.checkNotNullExpressionValue(zoneId, "toZoneId(...)");
        return zoneId;
    }

    /*
     * WARNING - void declaration
     */
    private final List<YearMonth> getPresentedMonths(ZoneId timezone, boolean isSysAdmin) {
        void $this$mapTo$iv$iv;
        ZonedDateTime nowInSystemTimeZone = ZonedDateTime.ofInstant(this.timeSupplier.get(), timezone);
        Period retentionPeriod = isSysAdmin ? this.auditRetentionConfigService.getConfig().getPeriod() : Period.ofMonths(12);
        Month currentMonth = nowInSystemTimeZone.getMonth();
        int currentYear = nowInSystemTimeZone.getYear();
        ZonedDateTime startOfRetentionPeriod = nowInSystemTimeZone.minus(retentionPeriod);
        Intrinsics.checkNotNull(currentMonth);
        int n = this.monthIndex(currentYear, currentMonth);
        int n2 = startOfRetentionPeriod.getYear();
        Month month = startOfRetentionPeriod.getMonth();
        Intrinsics.checkNotNullExpressionValue(month, "getMonth(...)");
        int totalMonthsInclusive = n - this.monthIndex(n2, month) + 1;
        int presentedMonthCount = RangesKt.coerceIn(totalMonthsInclusive, 1, 12);
        Iterable $this$map$iv = RangesKt.until(0, presentedMonthCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int n3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Month month2 = currentMonth.minus((long)i);
            int year = month2.compareTo((Enum)currentMonth) > 0 ? currentYear - 1 : currentYear;
            Intrinsics.checkNotNull(month2);
            collection.add(new YearMonth(month2, year));
        }
        return (List)destination$iv$iv;
    }

    private final long getUserMonthAuditUsage(UserReference user, YearMonth yearMonth) {
        return this.cachingAuditUsageService.getUserMonthAuditUsage(user.getAuditId(), yearMonth.getMonth(), yearMonth.getYear());
    }

    private final Map<AlertStatus, Long> getUserMonthSecurityAlertCounts(UserReference user, YearMonth yearMonth) {
        String string = user.getKey().getStringValue();
        Intrinsics.checkNotNullExpressionValue(string, "getStringValue(...)");
        return this.cachingUserAlertStatusCountsManager.getUserAlertStatusCountsForMonth(string, yearMonth.getMonth(), yearMonth.getYear());
    }

    private final int monthIndex(int currentYear, Month currentMonth) {
        return currentYear * 12 + (currentMonth.getValue() - 1);
    }

    public void afterPropertiesSet() {
        ExecutorService executorService = this.threadLocalDelegateExecutorFactory.createExecutorService((ExecutorService)new ThreadPoolExecutor(0, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue()));
        Intrinsics.checkNotNullExpressionValue(executorService, "createExecutorService(...)");
        this.authContextRetainingExecutorService = executorService;
    }

    public void destroy() {
        ExecutorService executorService = this.authContextRetainingExecutorService;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("authContextRetainingExecutorService");
            executorService = null;
        }
        executorService.shutdownNow();
    }

    private static final Object runAllTasksAsync$lambda$2$lambda$1(Function1 $task, Object $input) {
        Intrinsics.checkNotNullParameter($task, "$task");
        return $task.invoke($input);
    }

    private static final Pair runAllTasksAsync$lambda$4$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Pair)$tmp0.invoke(p0, p1);
    }

    private static final List runAllTasksAsync$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ long access$getUserMonthAuditUsage(UserUsageStatisticsServiceImpl $this, UserReference user, YearMonth yearMonth) {
        return $this.getUserMonthAuditUsage(user, yearMonth);
    }

    public static final /* synthetic */ Map access$getUserMonthSecurityAlertCounts(UserUsageStatisticsServiceImpl $this, UserReference user, YearMonth yearMonth) {
        return $this.getUserMonthSecurityAlertCounts(user, yearMonth);
    }
}

