/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.util.matchers.announcement.banner;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.matchers.audit.log.AuditEntityExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/lighthouse/util/matchers/announcement/banner/JiraAnnouncementBannerFunctions;", "", "()V", "contentFrom", "", "it", "Lcom/atlassian/audit/entity/AuditEntity;", "contentTo", "isBannerAdded", "", "isBannerContentAdded", "isBannerContentDeleted", "isBannerContentUpdated", "isBannerDeleted", "isBannerUpdated", "isBannerVisibilityUpdated", "visibilityFrom", "visibilityTo", "atlassian-lighthouse-core"})
public final class JiraAnnouncementBannerFunctions {
    @NotNull
    public static final JiraAnnouncementBannerFunctions INSTANCE = new JiraAnnouncementBannerFunctions();

    private JiraAnnouncementBannerFunctions() {
    }

    public final boolean isBannerAdded(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.isBannerContentAdded(it);
    }

    public final boolean isBannerDeleted(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.isBannerContentDeleted(it);
    }

    public final boolean isBannerUpdated(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.isBannerContentUpdated(it) || this.isBannerVisibilityUpdated(it) && !this.isBannerContentAdded(it) && !this.isBannerContentDeleted(it);
    }

    private final boolean isBannerContentAdded(AuditEntity it) {
        CharSequence charSequence = this.contentFrom(it);
        return (charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)this.contentTo(it)) == null || charSequence.length() == 0);
    }

    private final boolean isBannerContentDeleted(AuditEntity it) {
        CharSequence charSequence = this.contentFrom(it);
        return !(charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)this.contentTo(it)) == null || charSequence.length() == 0);
    }

    private final boolean isBannerVisibilityUpdated(AuditEntity it) {
        String visibilityFrom = this.visibilityFrom(it);
        String visibilityTo = this.visibilityTo(it);
        CharSequence charSequence = visibilityFrom;
        return !(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)visibilityTo) == null || charSequence.length() == 0) && !Intrinsics.areEqual(visibilityFrom, visibilityTo);
    }

    private final boolean isBannerContentUpdated(AuditEntity it) {
        String contentFrom = this.contentFrom(it);
        String contentTo = this.contentTo(it);
        CharSequence charSequence = contentFrom;
        return !(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)contentTo) == null || charSequence.length() == 0) && !Intrinsics.areEqual(contentFrom, contentTo);
    }

    private final String contentFrom(AuditEntity it) {
        return AuditEntityExtensionsKt.getChangedValueFrom(it, "jira.auditing.announcement.banner.content");
    }

    private final String contentTo(AuditEntity it) {
        return AuditEntityExtensionsKt.getChangedValueTo(it, "jira.auditing.announcement.banner.content");
    }

    private final String visibilityFrom(AuditEntity it) {
        return AuditEntityExtensionsKt.getChangedValueFrom(it, "jira.auditing.announcement.banner.visibility");
    }

    private final String visibilityTo(AuditEntity it) {
        return AuditEntityExtensionsKt.getChangedValueTo(it, "jira.auditing.announcement.banner.visibility");
    }
}

