/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.util.matchers.changed.values;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.config.alerts.ChangedValueSettings;
import com.atlassian.lighthouse.matchers.audit.log.AuditEntityExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tH\u0002J0\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lcom/atlassian/lighthouse/util/matchers/changed/values/ChangedValuesDetectionFunctions;", "", "()V", "convertToFromToMap", "", "", "auditEntity", "Lcom/atlassian/audit/entity/AuditEntity;", "changedValuesConfigEntry", "", "getChangedValuesMatcherAttributes", "changedValuesConfig", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nChangedValuesDetectionFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangedValuesDetectionFunctions.kt\ncom/atlassian/lighthouse/util/matchers/changed/values/ChangedValuesDetectionFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,34:1\n1549#2:35\n1620#2,3:36\n2661#2,7:39\n494#3,7:46\n*S KotlinDebug\n*F\n+ 1 ChangedValuesDetectionFunctions.kt\ncom/atlassian/lighthouse/util/matchers/changed/values/ChangedValuesDetectionFunctions\n*L\n16#1:35\n16#1:36,3\n17#1:39,7\n18#1:46,7\n*E\n"})
public final class ChangedValuesDetectionFunctions {
    @NotNull
    public static final ChangedValuesDetectionFunctions INSTANCE = new ChangedValuesDetectionFunctions();

    private ChangedValuesDetectionFunctions() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getChangedValuesMatcherAttributes(@NotNull Map<String, String> changedValuesConfig, @NotNull AuditEntity auditEntity) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(changedValuesConfig, "changedValuesConfig");
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        if (changedValuesConfig.isEmpty() || auditEntity.getChangedValues().isEmpty()) {
            return MapsKt.emptyMap();
        }
        Iterable $this$map$iv = changedValuesConfig.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.convertToFromToMap(auditEntity, (Map.Entry<String, String>)it));
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            Map $i$f$mapTo2 = (Map)iterator$iv.next();
            Map p0 = (Map)accumulator$iv;
            boolean bl = false;
            accumulator$iv = MapsKt.plus(p0, p1);
        }
        Map $this$filterValues$iv = (Map)accumulator$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return MapsKt.toMap(result$iv);
    }

    private final Map<String, String> convertToFromToMap(AuditEntity auditEntity, Map.Entry<String, String> changedValuesConfigEntry) {
        ChangedValueSettings changedValueSettings = ChangedValueSettings.Companion.from(changedValuesConfigEntry.getKey());
        if (changedValueSettings == null) {
            return MapsKt.emptyMap();
        }
        ChangedValueSettings setting = changedValueSettings;
        Pair[] pairArray = new Pair[]{TuplesKt.to(setting.getFrom(), AuditEntityExtensionsKt.getChangedValueFrom(auditEntity, changedValuesConfigEntry.getValue())), TuplesKt.to(setting.getTo(), AuditEntityExtensionsKt.getChangedValueTo(auditEntity, changedValuesConfigEntry.getValue()))};
        return MapsKt.mapOf(pairArray);
    }
}

