/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.util.matchers.permissions;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.lighthouse.matchers.audit.log.AuditEntityExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/lighthouse/util/matchers/permissions/BitbucketPermissionFunctions;", "", "()V", "extractChangedOrNewlyAddedPermission", "", "it", "Lcom/atlassian/audit/entity/AuditEntity;", "isAdminOrSysAdminPermission", "", "toPermissionType", "Lcom/atlassian/bitbucket/permission/Permission;", "permissionTypeName", "isGroupPermission", "permissionHasBeenDemotedFromAdminOrSystemAdmin", "permissionHasBeenElevatedToAdminOrSystemAdmin", "permissionHasBeenRevokedFromAdminOrSystemAdmin", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nBitbucketPermissionFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitbucketPermissionFunctions.kt\ncom/atlassian/lighthouse/util/matchers/permissions/BitbucketPermissionFunctions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class BitbucketPermissionFunctions {
    @NotNull
    public static final BitbucketPermissionFunctions INSTANCE = new BitbucketPermissionFunctions();

    private BitbucketPermissionFunctions() {
    }

    @Nullable
    public final String extractChangedOrNewlyAddedPermission(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String newPermissionAdded = AuditEntityExtensionsKt.getExtraAttributeValue(it, "bitbucket.service.user.audit.attribute.permission.permission");
        String changedPermissionType = AuditEntityExtensionsKt.getChangedValueTo(it, "bitbucket.service.user.audit.attribute.permission.permission");
        String string = newPermissionAdded;
        if (string == null) {
            string = changedPermissionType;
        }
        String finalPermissionType = string;
        return finalPermissionType;
    }

    public final boolean permissionHasBeenRevokedFromAdminOrSystemAdmin(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String permissionRevoked = AuditEntityExtensionsKt.getExtraAttributeValue(it, "bitbucket.service.user.audit.attribute.permission.permission");
        return this.isAdminOrSysAdminPermission(permissionRevoked);
    }

    public final boolean permissionHasBeenDemotedFromAdminOrSystemAdmin(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String fromPermissionType = AuditEntityExtensionsKt.getChangedValueFrom(it, "bitbucket.service.user.audit.attribute.permission.permission");
        String toPermissionType = AuditEntityExtensionsKt.getChangedValueTo(it, "bitbucket.service.user.audit.attribute.permission.permission");
        if (fromPermissionType == null || toPermissionType == null) {
            return false;
        }
        return this.isAdminOrSysAdminPermission(fromPermissionType) && Permission.valueOf((String)toPermissionType).getWeight() < Permission.valueOf((String)fromPermissionType).getWeight();
    }

    /*
     * Unable to fully structure code
     */
    public final boolean permissionHasBeenElevatedToAdminOrSystemAdmin(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        var3_2 = AuditEntityExtensionsKt.getChangedValueFrom(it, "bitbucket.service.user.audit.attribute.permission.permission");
        if (var3_2 == null) ** GOTO lbl-1000
        it = var3_2;
        $i$a$-let-BitbucketPermissionFunctions$permissionHasBeenElevatedToAdminOrSystemAdmin$fromPermissionType$1 = false;
        var4_5 = Permission.valueOf((String)it);
        if (var4_5 != null) {
            v0 = var4_5;
        } else lbl-1000:
        // 2 sources

        {
            v0 = Permission.REPO_READ;
        }
        fromPermissionType = v0;
        v1 = this.extractChangedOrNewlyAddedPermission(it);
        if (v1 != null) {
            it = v1;
            $i$a$-let-BitbucketPermissionFunctions$permissionHasBeenElevatedToAdminOrSystemAdmin$toPermissionType$1 = false;
            v2 = Permission.valueOf((String)it);
        } else {
            v2 = toPermissionType = null;
        }
        if (toPermissionType == null) {
            return false;
        }
        return this.isAdminOrSysAdminPermission(toPermissionType) != false && toPermissionType.getWeight() > fromPermissionType.getWeight();
    }

    public final boolean isGroupPermission(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return AuditEntityExtensionsKt.getExtraAttributeValue(it, "bitbucket.service.user.audit.attribute.permission.group") != null;
    }

    public final boolean isAdminOrSysAdminPermission(@Nullable Permission toPermissionType) {
        return Permission.ADMIN == toPermissionType || Permission.SYS_ADMIN == toPermissionType;
    }

    private final boolean isAdminOrSysAdminPermission(String permissionTypeName) {
        return Intrinsics.areEqual("ADMIN", permissionTypeName) || Intrinsics.areEqual("SYS_ADMIN", permissionTypeName);
    }
}

