/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.cloud.connect.companion.client;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugins.cloud.connect.companion.client.CloudContext;
import com.atlassian.plugins.cloud.connect.companion.client.CloudLink;
import com.atlassian.plugins.cloud.connect.companion.client.CloudObjectMapper;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequest;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestExecutionException;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestMethod;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestService;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceNotAvailableException;
import com.atlassian.plugins.cloud.connect.companion.client.CloudResponse;
import com.atlassian.plugins.cloud.connect.companion.client.DataSharingLevel;
import com.atlassian.plugins.cloud.connect.companion.client.DataSharingLevelAwareCloudContext;
import com.atlassian.plugins.cloud.connect.companion.client.GenericTypeReference;
import com.atlassian.plugins.cloud.connect.companion.client.IncompatibleServiceException;
import com.atlassian.plugins.cloud.connect.inter.api.CloudContextInternal;
import com.atlassian.plugins.cloud.connect.inter.api.CloudObjectMapperInternal;
import com.atlassian.plugins.cloud.connect.inter.api.CloudRequestExecutionExceptionInternal;
import com.atlassian.plugins.cloud.connect.inter.api.CloudRequestInternal;
import com.atlassian.plugins.cloud.connect.inter.api.CloudRequestMethodInternal;
import com.atlassian.plugins.cloud.connect.inter.api.CloudRequestServiceInternal;
import com.atlassian.plugins.cloud.connect.inter.api.CloudResponseInternal;
import com.atlassian.plugins.cloud.connect.inter.api.DataSharingLevelInternal;
import com.atlassian.plugins.cloud.connect.inter.api.GenericTypeReferenceInternal;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.util.tracker.ServiceTracker;

public final class CloudRequestServiceTranslatingProxy
implements CloudRequestService {
    private final ServiceTracker serviceTracker;

    CloudRequestServiceTranslatingProxy(ServiceTracker serviceTracker) {
        this.serviceTracker = serviceTracker;
    }

    @Override
    public <R, T> CloudResponse<R> sendRequest(CloudRequest<T> request, Class<R> responseType, CloudObjectMapper objectMapper) throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        if (this.isPresent()) {
            CloudRequestServiceInternal target = (CloudRequestServiceInternal)this.serviceTracker.getService();
            try {
                CloudResponseInternal responseInternal = target.sendRequest(CloudRequestServiceTranslatingProxy.toCloudRequestInternal(request), responseType, (CloudObjectMapperInternal)new TranslatingCloudObjectMapper(objectMapper));
                return CloudRequestServiceTranslatingProxy.toCloudResponse(responseInternal);
            }
            catch (CloudRequestExecutionExceptionInternal e) {
                throw new CloudRequestExecutionException(e.getMessage(), e);
            }
        }
        throw new CloudRequestServiceNotAvailableException();
    }

    @Override
    public <R, T> CloudResponse<R> sendRequest(CloudRequest<T> request, GenericTypeReference<R> responseType, CloudObjectMapper objectMapper) throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        if (this.isPresent()) {
            CloudRequestServiceInternal target = (CloudRequestServiceInternal)this.serviceTracker.getService();
            CloudResponseInternal responseInternal = target.sendRequest(CloudRequestServiceTranslatingProxy.toCloudRequestInternal(request), new GenericTypeReferenceInternal<R>(this){}, (CloudObjectMapperInternal)new TranslatingCloudObjectMapper(objectMapper));
            return CloudRequestServiceTranslatingProxy.toCloudResponse(responseInternal);
        }
        throw new CloudRequestServiceNotAvailableException();
    }

    @Override
    public boolean isPresent() {
        return this.serviceTracker.getService() != null;
    }

    @Override
    public Optional<CloudLink> getCloudLink() throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        if (this.isPresent()) {
            CloudRequestServiceInternal target = (CloudRequestServiceInternal)this.serviceTracker.getService();
            try {
                return target.getCloudLinkDetails().map(cloudLink -> new CloudLink(cloudLink.getOrgId(), cloudLink.getOrgName(), CloudRequestServiceTranslatingProxy.fromDataSharingLevelInternal(cloudLink.getDataSharingLevel())));
            }
            catch (NoSuchMethodError e) {
                throw new IncompatibleServiceException("getCloudLinkDetails() not found. Upgrade CCC to the latest version.");
            }
        }
        throw new CloudRequestServiceNotAvailableException();
    }

    private static <T> CloudRequestInternal<T> toCloudRequestInternal(CloudRequest<T> cloudRequest) throws IncompatibleServiceException {
        return CloudRequestInternal.builder(cloudRequest.getBody().orElse(null)).method(CloudRequestServiceTranslatingProxy.toHttpMethodInternal(cloudRequest.getMethod())).url(cloudRequest.getUrl()).cloudContext(CloudRequestServiceTranslatingProxy.toCloudContextInternal(cloudRequest.getCloudContext())).headers(cloudRequest.getHeaders()).build();
    }

    private static CloudRequestMethodInternal toHttpMethodInternal(CloudRequestMethod cloudRequestMethod) {
        return CloudRequestMethodInternal.valueOf((String)cloudRequestMethod.name());
    }

    private static CloudContextInternal toCloudContextInternal(CloudContext cloudContext) throws IncompatibleServiceException {
        if (cloudContext instanceof DataSharingLevelAwareCloudContext) {
            return CloudContextInternal.withMinimumDataSharingLevel((DataSharingLevelInternal)CloudRequestServiceTranslatingProxy.toDataSharingLevelInternal(((DataSharingLevelAwareCloudContext)cloudContext).getDataSharingLevel()));
        }
        return CloudContextInternal.withMinimumDataSharingLevel((DataSharingLevelInternal)DataSharingLevelInternal.LIMITED);
    }

    private static DataSharingLevelInternal toDataSharingLevelInternal(DataSharingLevel dataSharingLevel) throws IncompatibleServiceException {
        try {
            return DataSharingLevelInternal.valueOf((String)dataSharingLevel.name());
        }
        catch (IllegalArgumentException e) {
            throw new IncompatibleServiceException("DataSharingLevelInternal." + dataSharingLevel.name() + " not found. Upgrade CCC to the latest version.");
        }
    }

    @VisibleForTesting
    static DataSharingLevel fromDataSharingLevelInternal(DataSharingLevelInternal dataSharingLevelInternal) {
        try {
            return DataSharingLevel.valueOf(dataSharingLevelInternal.name());
        }
        catch (IllegalArgumentException e) {
            if (dataSharingLevelInternal.isLowestLevel()) {
                return DataSharingLevel.LIMITED;
            }
            return CloudRequestServiceTranslatingProxy.fromDataSharingLevelInternal(dataSharingLevelInternal.getOneLevelLower());
        }
    }

    private static <R> CloudResponse<R> toCloudResponse(final CloudResponseInternal<R> cloudResponseInternal) {
        return new CloudResponse<R>(){

            @Override
            public int getStatusCode() {
                return cloudResponseInternal.getStatusCode();
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                return cloudResponseInternal.getHeaders();
            }

            @Override
            public R getBody() {
                return cloudResponseInternal.getBody();
            }
        };
    }

    private static class TranslatingCloudObjectMapper
    implements CloudObjectMapperInternal {
        private final CloudObjectMapper objectMapper;

        public TranslatingCloudObjectMapper(CloudObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public <S> S readValue(byte[] src, Class<S> valueType) throws IOException {
            return this.objectMapper.readValue(src, valueType);
        }

        public byte[] writeValueAsBytes(Object value) throws IOException {
            return this.objectMapper.writeValueAsBytes(value);
        }
    }
}

