/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.cloud.connect.companion.client;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class GenericTypeReference<T> {
    private final Type type;

    protected GenericTypeReference() {
        Class<?> parameterizedTypeReferenceSubclass = GenericTypeReference.findParameterizedTypeReferenceSubclass(this.getClass());
        Type type = parameterizedTypeReferenceSubclass.getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Type must be a parameterized type");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length != 1) {
            throw new IllegalArgumentException("Number of type arguments must be 1");
        }
        this.type = actualTypeArguments[0];
    }

    private GenericTypeReference(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof GenericTypeReference && this.type.equals(((GenericTypeReference)other).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "ParameterizedTypeReference<" + String.valueOf(this.type) + ">";
    }

    public static <T> GenericTypeReference<T> forType(Type type) {
        return new GenericTypeReference<T>(type){};
    }

    private static Class<?> findParameterizedTypeReferenceSubclass(Class<?> child) {
        Class<?> parent = child.getSuperclass();
        if (Object.class == parent) {
            throw new IllegalStateException("Expected ParameterizedTypeReference superclass");
        }
        if (GenericTypeReference.class == parent) {
            return child;
        }
        return GenericTypeReference.findParameterizedTypeReferenceSubclass(parent);
    }
}

