/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.bamboo;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.bitbucket.build.server.PluginBuildServer;
import com.atlassian.bitbucket.build.server.PluginBuildServerProvider;
import com.atlassian.bitbucket.dmz.auth.Anonymous2LORequestVerifier;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.bamboo.BambooPluginBuildServer;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.oauth.util.RequestAnnotations;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BambooBuildServerProvider
implements PluginBuildServerProvider {
    private static final Logger log = LoggerFactory.getLogger(BambooBuildServerProvider.class);
    private final Anonymous2LORequestVerifier anonymous2LORequestVerifier;
    private final ApplicationLinkService applicationLinkService;
    private final I18nService i18nService;

    public BambooBuildServerProvider(Anonymous2LORequestVerifier anonymous2LORequestVerifier, ApplicationLinkService applicationLinkService, I18nService i18nService) {
        this.anonymous2LORequestVerifier = anonymous2LORequestVerifier;
        this.applicationLinkService = applicationLinkService;
        this.i18nService = i18nService;
    }

    public Optional<PluginBuildServer> getBuildServer(@Nonnull String id) {
        Objects.requireNonNull(id, "id");
        try {
            return Optional.ofNullable(this.applicationLinkService.getApplicationLink(new ApplicationId(id))).map(applink -> new BambooPluginBuildServer((ApplicationLink)applink, this.i18nService));
        }
        catch (TypeNotInstalledException tynie) {
            log.warn("Could not retrieve build server", (Throwable)tynie);
            return Optional.empty();
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
    }

    @Nonnull
    public Optional<PluginBuildServer> getBuildServer(@Nonnull HttpServletRequest servletRequest, @Nonnull Map<String, Object> requestBody) {
        String remoteClientId;
        Objects.requireNonNull(servletRequest, "servletRequest");
        if (this.anonymous2LORequestVerifier.isValidOAuth1()) {
            return this.findBambooServerByConsumerKey(RequestAnnotations.getOAuthConsumerKey((HttpServletRequest)servletRequest));
        }
        if (this.anonymous2LORequestVerifier.isValidOAuth2(Set.of("REPO_READ")) && !(remoteClientId = Objects.toString(servletRequest.getAttribute("oauth2.token.client_configuration_id"), "")).isBlank()) {
            return this.findBambooServerByClientId(remoteClientId);
        }
        return Optional.empty();
    }

    private Optional<PluginBuildServer> findBambooServerByApplicationLink(@Nonnull Predicate<? super ApplicationLink> filter) {
        return MoreStreams.streamIterable((Iterable)this.applicationLinkService.getApplicationLinks(BambooApplicationType.class)).filter(filter).findFirst().map(applicationLink -> new BambooPluginBuildServer((ApplicationLink)applicationLink, this.i18nService));
    }

    private Optional<PluginBuildServer> findBambooServerByClientId(@Nonnull String clientId) {
        log.debug("Searching for Application Link by client id '{}'", (Object)clientId);
        return this.findBambooServerByApplicationLink(applink -> clientId.equals(applink.getClientId()));
    }

    private Optional<PluginBuildServer> findBambooServerByConsumerKey(@Nonnull String consumerKey) {
        log.debug("Searching for Application Link by consumer key '{}'", (Object)consumerKey);
        return this.findBambooServerByApplicationLink(applink -> consumerKey.equals(applink.getProperty("oauth.incoming.consumerkey")));
    }
}

