/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.bamboo;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bitbucket.build.server.operations.ActionResult;
import com.atlassian.bitbucket.build.server.operations.ActionState;
import com.atlassian.bitbucket.build.server.operations.BuildOperations;
import com.atlassian.bitbucket.build.server.operations.BuildStatusAction;
import com.atlassian.bitbucket.build.server.operations.BuildStatusActionRequest;
import com.atlassian.bitbucket.build.server.operations.PluginBuildServerClient;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.bamboo.actions.ActionRunner;
import com.atlassian.bitbucket.internal.build.bamboo.actions.BambooActionResult;
import com.atlassian.bitbucket.internal.build.bamboo.actions.ContinuePlanAction;
import com.atlassian.bitbucket.internal.build.bamboo.actions.ContinuePlanActionRunner;
import com.atlassian.bitbucket.internal.build.bamboo.actions.RerunFailedJobsAction;
import com.atlassian.bitbucket.internal.build.bamboo.actions.RunPlanAction;
import com.atlassian.bitbucket.internal.build.bamboo.actions.RunPlanActionRunner;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooBuildStatus;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooClient;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooResponse;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooStage;
import com.atlassian.bitbucket.internal.build.bamboo.operations.BambooBuildOperations;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BambooPluginBuildServerClient
implements PluginBuildServerClient {
    private static final Logger log = LoggerFactory.getLogger(BambooPluginBuildServerClient.class);
    private final ApplicationLink applicationLink;
    private final BambooClient bambooClient;
    private final I18nService i18nService;

    @VisibleForTesting
    BambooPluginBuildServerClient(ApplicationLink applicationLink, BambooClient bambooClient, I18nService i18nService) {
        this.applicationLink = applicationLink;
        this.bambooClient = bambooClient;
        this.i18nService = i18nService;
    }

    public BambooPluginBuildServerClient(ApplicationLink applicationLink, I18nService i18nService) {
        this(applicationLink, new BambooClient(applicationLink, i18nService), i18nService);
    }

    @Nonnull
    public Optional<BuildStatusAction> getAction(@Nonnull RepositoryBuildStatus buildStatus, @Nonnull String actionId) {
        if (!this.isValidBuildStatus(buildStatus)) {
            return Optional.empty();
        }
        if (RerunFailedJobsAction.ID.equals(actionId)) {
            return Optional.of(new RerunFailedJobsAction(this.i18nService));
        }
        if (RunPlanAction.ID.equals(actionId)) {
            return Optional.of(new RunPlanAction(this.i18nService));
        }
        if (ContinuePlanAction.ID.equals(actionId)) {
            return Optional.of(new ContinuePlanAction(this.i18nService));
        }
        return Optional.empty();
    }

    @Nonnull
    public URI getAuthorizationUrl(@Nonnull URI callback) {
        return this.bambooClient.getAuthorizationUrl(callback);
    }

    @Nonnull
    public URI getAuthorizationUrl() {
        return this.bambooClient.getAuthorizationUrl();
    }

    @Nonnull
    public BuildOperations getOperations(@Nonnull RepositoryBuildStatus buildStatus) {
        Objects.requireNonNull(buildStatus, "buildStatus");
        BambooBuildOperations.Builder builder = new BambooBuildOperations.Builder();
        if (!this.isValidBuildStatus(buildStatus)) {
            return builder.build();
        }
        BambooResponse<BambooBuildStatus> buildStatusResponse = this.bambooClient.getBuildStatus(buildStatus.getKey(), buildStatus.getBuildNumber().orElse("latest"));
        builder.isAuthorizationRequired(buildStatusResponse.isAuthorizationRequired());
        if (buildStatusResponse.isSuccessful()) {
            buildStatusResponse.getEntity().ifPresent(bambooBuildStatus -> {
                if (bambooBuildStatus.isFinished()) {
                    if (bambooBuildStatus.isContinuable()) {
                        bambooBuildStatus.getStages().stream().filter(BambooStage::isRunnable).findFirst().ifPresent(nextRunnableStage -> builder.actions(new ContinuePlanAction(this.i18nService, (BambooStage)nextRunnableStage)));
                    } else if (bambooBuildStatus.isRestartable()) {
                        builder.actions(new RerunFailedJobsAction(this.i18nService));
                    }
                }
            });
            builder.actions(new RunPlanAction(this.i18nService));
        }
        return builder.build();
    }

    public boolean isAuthorizationRequired() {
        return this.bambooClient.isAuthorizationRequired();
    }

    @Nonnull
    public ActionResult performAction(@Nonnull BuildStatusActionRequest request) {
        Objects.requireNonNull(request, "request");
        if (!this.isValidBuildStatus(request.getBuildStatus())) {
            return new BambooActionResult.Builder(ActionState.FAILED).message(this.i18nService.getMessage("bitbucket.build.bamboo.action.buildserver.invalid", new Object[]{request.getBuildAction().getName(), request.getBuildStatus().getKey()})).build();
        }
        return this.getActionRunner(request.getBuildAction()).map(runner -> runner.run(request.getBuildStatus())).orElseGet(() -> new BambooActionResult.Builder(ActionState.FAILED).message(this.i18nService.getMessage("bitbucket.build.bamboo.action.invalid", new Object[]{request.getBuildAction().getName()})).build());
    }

    private Optional<ActionRunner> getActionRunner(BuildStatusAction action) {
        if (RerunFailedJobsAction.ID.equals(action.getId())) {
            return Optional.of(new ContinuePlanActionRunner(this.applicationLink.getName(), this.bambooClient, this.i18nService, true));
        }
        if (RunPlanAction.ID.equals(action.getId())) {
            return Optional.of(new RunPlanActionRunner(this.applicationLink, this.bambooClient, this.i18nService));
        }
        if (ContinuePlanAction.ID.equals(action.getId())) {
            return Optional.of(new ContinuePlanActionRunner(this.applicationLink.getName(), this.bambooClient, this.i18nService, false));
        }
        return Optional.empty();
    }

    private boolean isValidBuildStatus(RepositoryBuildStatus buildStatus) {
        return buildStatus.getBuildServer().map(buildServer -> this.applicationLink.getId().get().equals(buildServer.getId())).orElse(false);
    }
}

