/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.bamboo.actions;

import com.atlassian.bitbucket.build.server.operations.ActionResult;
import com.atlassian.bitbucket.build.server.operations.ActionState;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public final class BambooActionResult
implements ActionResult {
    private final String message;
    private final ActionState state;
    private final URI uri;

    private BambooActionResult(Builder builder) {
        this.message = builder.message;
        this.state = builder.state;
        this.uri = builder.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BambooActionResult that = (BambooActionResult)o;
        return Objects.equals(this.message, that.message) && this.state == that.state && Objects.equals(this.uri, that.uri);
    }

    @Nonnull
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Nonnull
    public ActionState getState() {
        return this.state;
    }

    @Nonnull
    public Optional<URI> getURI() {
        return Optional.ofNullable(this.uri);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.state, this.uri);
    }

    public static final class Builder
    extends BuilderSupport {
        private final ActionState state;
        private String message;
        private URI uri;

        public Builder(@Nonnull ActionState state) {
            this.state = Objects.requireNonNull(state, "state");
        }

        @Nonnull
        public ActionResult build() {
            return new BambooActionResult(this);
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = value;
            return this;
        }

        @Nonnull
        public Builder uri(@Nullable URI value) {
            this.uri = value;
            return this;
        }
    }
}

