/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.bamboo.actions;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.server.operations.ActionResult;
import com.atlassian.bitbucket.build.server.operations.ActionState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.bamboo.actions.ActionRunner;
import com.atlassian.bitbucket.internal.build.bamboo.actions.BambooActionResult;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooClient;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooResponse;
import com.atlassian.bitbucket.internal.build.bamboo.client.QueuedBuild;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

public class ContinuePlanActionRunner
implements ActionRunner {
    private final String applicationLinkName;
    private final BambooClient bambooClient;
    private final I18nService i18nService;
    private final boolean isRerun;

    public ContinuePlanActionRunner(@Nonnull String applicationLinkName, @Nonnull BambooClient bambooClient, @Nonnull I18nService i18nService, boolean isRerun) {
        this.applicationLinkName = applicationLinkName;
        this.bambooClient = bambooClient;
        this.i18nService = i18nService;
        this.isRerun = isRerun;
    }

    @Override
    @Nonnull
    public ActionResult run(@Nonnull RepositoryBuildStatus buildStatus) {
        String buildNumber;
        Optional maybeBuildNumber = buildStatus.getBuildNumber();
        if (!maybeBuildNumber.isPresent()) {
            return new BambooActionResult.Builder(ActionState.ERROR).message(this.i18nService.getMessage("bitbucket.build.bamboo.action.continuePlan.buildnumberrequired", new Object[0])).build();
        }
        if (buildStatus.getState() == BuildState.INPROGRESS) {
            return new BambooActionResult.Builder(ActionState.ERROR).message(this.i18nService.getMessage("bitbucket.build.bamboo.action.continuePlan.inprogress", new Object[0])).build();
        }
        String planKey = buildStatus.getKey();
        BambooResponse<QueuedBuild> response = this.bambooClient.continueBuild(planKey, buildNumber = (String)maybeBuildNumber.get());
        if (response.isSuccessful()) {
            return response.getEntity().map(entity -> {
                BambooActionResult.Builder builder = entity.getBuildNumber() == Integer.parseInt(buildNumber) ? new BambooActionResult.Builder(ActionState.SUCCESSFUL).message(this.i18nService.getMessage(this.getSuccessfulMessageKey(), new Object[]{planKey, buildNumber, this.applicationLinkName})) : new BambooActionResult.Builder(ActionState.ERROR).message(this.i18nService.getMessage("bitbucket.build.bamboo.action.continuePlan.badbuildnumber", new Object[]{this.applicationLinkName}));
                try {
                    URI uri = new URI(entity.getLink().getHref());
                    builder.uri(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return builder.build();
            }).orElseGet(() -> new BambooActionResult.Builder(ActionState.SUCCESSFUL).message(this.i18nService.getMessage(this.getSuccessfulMessageKey(), new Object[]{planKey, buildNumber, this.applicationLinkName})).build());
        }
        return new BambooActionResult.Builder(ActionState.FAILED).message(response.getMessage().orElseGet(() -> this.i18nService.getMessage("bitbucket.build.bamboo.request.failed.unknown", new Object[]{this.applicationLinkName}))).build();
    }

    private String getSuccessfulMessageKey() {
        return this.isRerun ? "bitbucket.build.bamboo.action.rerunfailedjobs.success" : "bitbucket.build.bamboo.action.continuePlan.success";
    }
}

