/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.bamboo.actions;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bitbucket.build.server.operations.ActionResult;
import com.atlassian.bitbucket.build.server.operations.ActionState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.bamboo.actions.ActionRunner;
import com.atlassian.bitbucket.internal.build.bamboo.actions.BambooActionResult;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooClient;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooResponse;
import com.atlassian.bitbucket.internal.build.bamboo.client.QueuedBuild;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.net.URISyntaxException;

public class RunPlanActionRunner
implements ActionRunner {
    private final ApplicationLink applicationLink;
    private final BambooClient bambooClient;
    private final I18nService i18nService;

    public RunPlanActionRunner(ApplicationLink applicationLink, BambooClient bambooClient, I18nService i18nService) {
        this.applicationLink = applicationLink;
        this.bambooClient = bambooClient;
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    public ActionResult run(@Nonnull RepositoryBuildStatus buildStatus) {
        String planKey = buildStatus.getKey();
        BambooResponse<QueuedBuild> response = this.bambooClient.runBuild(planKey);
        if (response.isSuccessful()) {
            return response.getEntity().map(entity -> {
                URI url = null;
                try {
                    url = new URI(entity.getLink().getHref());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return new BambooActionResult.Builder(ActionState.SUCCESSFUL).message(this.i18nService.getMessage("bitbucket.build.bamboo.request.success", new Object[]{entity.getBuildNumber(), planKey, this.applicationLink.getName()})).uri(url).build();
            }).orElseGet(() -> new BambooActionResult.Builder(ActionState.SUCCESSFUL).message(this.i18nService.getMessage("bitbucket.build.bamboo.request.success.minimal", new Object[]{planKey, this.applicationLink.getName()})).build());
        }
        return new BambooActionResult.Builder(ActionState.FAILED).message(response.getMessage().orElseGet(() -> this.i18nService.getMessage("bitbucket.build.bamboo.request.failed.unknown", new Object[]{this.applicationLink.getName()}))).build();
    }
}

