/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.bamboo.client;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooBuildStatus;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooError;
import com.atlassian.bitbucket.internal.build.bamboo.client.BambooResponse;
import com.atlassian.bitbucket.internal.build.bamboo.client.QueuedBuild;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BambooClient {
    public static final String API_PREFIX = "/rest/api/latest/";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(BambooClient.class);
    private final ApplicationLink applink;
    private final I18nService i18nService;

    public BambooClient(ApplicationLink applink, I18nService i18nService) {
        this.applink = applink;
        this.i18nService = i18nService;
    }

    public BambooResponse<QueuedBuild> continueBuild(String key, String buildNumber) {
        return this.performRequest(Request.MethodType.PUT, "/rest/api/latest/queue/" + key + "-" + buildNumber, QueuedBuild.class);
    }

    public URI getAuthorizationUrl(URI callback) {
        return this.getRequestFactory().getAuthorisationURI(callback);
    }

    public URI getAuthorizationUrl() {
        return this.getRequestFactory().getAuthorisationURI();
    }

    public BambooResponse<BambooBuildStatus> getBuildStatus(String plan, String buildNumber) {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)API_PREFIX).path("result").path(plan).path(buildNumber).queryParam("expand", new Object[]{"stages"});
        return this.performRequest(Request.MethodType.GET, uriBuilder.build(new Object[0]).toString(), BambooBuildStatus.class);
    }

    public boolean isAuthorizationRequired() {
        return this.performRequest(Request.MethodType.GET, "/rest/api/latest/project", Void.class).isAuthorizationRequired();
    }

    public BambooResponse<QueuedBuild> runBuild(String key) {
        return this.performRequest(Request.MethodType.POST, "/rest/api/latest/queue/" + key, QueuedBuild.class);
    }

    private static boolean isAuthorizationRequired(Response response) throws ResponseException {
        return response.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode() && response.getResponseBodyAsString().contains("oauth_problem");
    }

    private ApplicationLinkRequestFactory getRequestFactory() {
        return this.applink.createAuthenticatedRequestFactory();
    }

    private String getResponseExceptionMessage(String baseMessage, String url) {
        return String.format("%s from request to Bamboo instance (%s, %s) on URL '%s'", baseMessage, this.applink.getName(), this.applink.getId(), url);
    }

    private String getUnsuccessfulResponseMessage(String method, String url, Response response) {
        Object message = String.format("%s request to Bamboo instance (%s, %s) on URL '%s' failed with status code %s.", method, this.applink.getName(), this.applink.getId(), url, response.getStatusCode());
        try {
            String responseBody = response.getResponseBodyAsString();
            if (!StringUtils.isBlank((CharSequence)responseBody)) {
                message = (String)message + String.format(" Detailed message: %s", responseBody);
            }
        }
        catch (ResponseException responseException) {
            // empty catch block
        }
        return message;
    }

    private <T> BambooResponse<T> performRequest(Request.MethodType methodType, String url, Class<T> entityClass) {
        BambooResponse.Builder responseBuilder = new BambooResponse.Builder();
        try {
            ApplicationLinkRequest request = (ApplicationLinkRequest)this.getRequestFactory().createRequest(methodType, url).addHeader("Accept", "application/json");
            request.execute(response -> {
                if (response.isSuccessful()) {
                    responseBuilder.successful(true);
                    try {
                        if (methodType != Request.MethodType.HEAD && !Void.class.equals((Object)entityClass)) {
                            Object entity = OBJECT_MAPPER.readValue(response.getResponseBodyAsStream(), entityClass);
                            responseBuilder.entity(entity);
                        }
                    }
                    catch (JsonParseException e) {
                        log.debug(this.getResponseExceptionMessage(url, "Error parsing response"), (Throwable)e);
                    }
                    catch (JsonMappingException e) {
                        log.debug(this.getResponseExceptionMessage(url, "Error mapping response"), (Throwable)e);
                    }
                    catch (ResponseException | IOException e) {
                        log.debug(this.getResponseExceptionMessage(url, "An error occurred reading response"), e);
                    }
                } else {
                    log.debug(this.getUnsuccessfulResponseMessage(methodType.name(), url, response));
                    responseBuilder.authorizationRequired(BambooClient.isAuthorizationRequired(response));
                    String message = null;
                    try {
                        BambooError entity = (BambooError)OBJECT_MAPPER.readValue(response.getResponseBodyAsStream(), BambooError.class);
                        message = entity.getMessage();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (StringUtils.isBlank(message)) {
                        message = response.getStatusText();
                    }
                    if (StringUtils.isBlank(message)) {
                        responseBuilder.message(this.i18nService.getMessage("bitbucket.build.bamboo.request.failed.unknown", new Object[]{this.applink.getName()}));
                    } else {
                        responseBuilder.message(this.i18nService.getMessage("bitbucket.build.bamboo.request.failed", new Object[]{this.applink.getName(), message}));
                    }
                }
            });
        }
        catch (CredentialsRequiredException e) {
            responseBuilder.authorizationRequired(true);
            responseBuilder.message(this.i18nService.getMessage("bitbucket.build.bamboo.request.credentialsrequired", new Object[0]));
        }
        catch (ResponseException e) {
            log.debug("Error calling out to remote Bamboo instance ({}, {})", new Object[]{this.applink.getName(), this.applink.getId(), e});
            responseBuilder.message(this.i18nService.getMessage("bitbucket.build.bamboo.request.error", new Object[]{this.applink.getName()}));
        }
        return responseBuilder.build();
    }
}

