/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.build.bamboo.client;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;

public class BambooResponse<T> {
    private final boolean authorizationRequired;
    private final T entity;
    private final String message;
    private final boolean successful;

    private BambooResponse(Builder<T> builder) {
        this.authorizationRequired = builder.authorizationRequired;
        this.successful = builder.successful;
        this.entity = builder.entity;
        this.message = builder.message;
    }

    @Nonnull
    public Optional<T> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    @Nonnull
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public boolean isAuthorizationRequired() {
        return this.authorizationRequired;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public static final class Builder<T> {
        public boolean authorizationRequired;
        private T entity;
        private String message;
        private boolean successful;

        public Builder<T> authorizationRequired(boolean value) {
            this.authorizationRequired = value;
            return this;
        }

        public BambooResponse<T> build() {
            return new BambooResponse(this);
        }

        public Builder<T> entity(@Nullable T value) {
            this.entity = value;
            return this;
        }

        public Builder<T> message(@Nullable String value) {
            this.message = value;
            return this;
        }

        public Builder<T> successful(boolean value) {
            this.successful = value;
            return this;
        }
    }
}

