/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.internal.integration.jira.rest;

import com.atlassian.internal.integration.jira.InternalJiraService;
import com.atlassian.internal.integration.jira.autocomplete.AutoCompleteItem;
import com.atlassian.internal.integration.jira.autocomplete.RestAutoCompleteContext;
import com.atlassian.internal.integration.jira.rest.RestUtils;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collection;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Path(value="/fields")
@Singleton
public class JiraFieldsResource {
    private final InternalJiraService jiraService;

    @Inject
    public JiraFieldsResource(InternalJiraService jiraService) {
        this.jiraService = jiraService;
    }

    @POST
    @Path(value="autocomplete")
    public Response getAutoCompleteData(RestAutoCompleteContext context) {
        Collection<AutoCompleteItem> items = this.jiraService.getAutoCompleteItems(context);
        return RestUtils.ok(items).build();
    }
}

