/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.internal.integration.jira.rest;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.integration.jira.JiraIssuesRequest;
import com.atlassian.internal.integration.jira.InternalJiraService;
import com.atlassian.internal.integration.jira.request.MyAssignedJiraIssuesRequest;
import com.atlassian.internal.integration.jira.rest.RestUtils;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Set;
import javax.annotation.Nonnull;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="/issues")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class JiraResource {
    private final InternalJiraService jiraService;

    @Inject
    public JiraResource(InternalJiraService jiraService) {
        this.jiraService = jiraService;
    }

    @POST
    public Response createIssues(@Nonnull @QueryParam(value="applicationId") ApplicationId id, String createIssueRequestJson) {
        return RestUtils.ok(this.jiraService.createIssues(id, createIssueRequestJson)).build();
    }

    @GET
    public Response getDetailsForIssueKeys(@QueryParam(value="issueKey") Set<String> issueKeys, @QueryParam(value="entityKey") String entityKey, @QueryParam(value="fields") String fields, @QueryParam(value="minimum") @DefaultValue(value="0") int minimum, @QueryParam(value="showErrors") boolean showErrors) {
        JiraIssuesRequest request = ((JiraIssuesRequest.Builder)((JiraIssuesRequest.Builder)new JiraIssuesRequest.Builder().entityKey(entityKey)).fields(JiraResource.parseFields(fields)).issueKeys(issueKeys)).minimum(minimum).showErrors(showErrors).build();
        return RestUtils.ok(this.jiraService.getIssuesAsJson(request)).build();
    }

    @GET
    @Path(value="{issueKey}/transitions")
    public Response getTransitions(@QueryParam(value="applicationId") ApplicationId id, @PathParam(value="issueKey") String issueKey) {
        return RestUtils.ok(this.jiraService.getIssueTransitionsAsJson(issueKey, id)).build();
    }

    @POST
    @Path(value="{issueKey}/transitions")
    public Response transition(@QueryParam(value="applicationId") ApplicationId id, @QueryParam(value="fields") String fields, @PathParam(value="issueKey") String issueKey, String transitionJson) {
        return RestUtils.ok(this.jiraService.transitionIssue(issueKey, JiraResource.parseFields(fields), id, transitionJson)).build();
    }

    @GET
    @Path(value="assignedToMe")
    public Response getIssuesAssignedToMe(@QueryParam(value="applicationId") ApplicationId applicationId, @QueryParam(value="fields") String fields, @QueryParam(value="maxResults") @DefaultValue(value="50") int maxResults, @QueryParam(value="startAt") @DefaultValue(value="0") int startAt, @QueryParam(value="nextPageToken") String nextPageToken, @Context UriInfo uriInfo) {
        MyAssignedJiraIssuesRequest request;
        MyAssignedJiraIssuesRequest.Builder requestBuilder = (MyAssignedJiraIssuesRequest.Builder)new MyAssignedJiraIssuesRequest.Builder(applicationId).fields(JiraResource.parseFields(fields)).maxResults(maxResults);
        if (this.jiraService.isJiraCloudAppLink(applicationId)) {
            JiraResource.validatePaginationParameterForSearchCloud(uriInfo);
            request = ((MyAssignedJiraIssuesRequest.Builder)requestBuilder.nextPageToken(nextPageToken)).build();
        } else {
            JiraResource.validatePaginationParameterForSearchDC(uriInfo);
            request = ((MyAssignedJiraIssuesRequest.Builder)requestBuilder.startAt(startAt)).build();
        }
        return RestUtils.ok(this.jiraService.getMyAssignedIssues(request)).build();
    }

    @GET
    @Path(value="findValidIssues")
    public Response findValidIssues(@QueryParam(value="applicationId") ApplicationId applicationId, @QueryParam(value="issueKeys") Set<String> issueKeys) {
        return RestUtils.ok(this.jiraService.findValidIssues(issueKeys, applicationId)).build();
    }

    private static Set<String> parseFields(String fields) {
        return ImmutableSet.copyOf((Object[])fields.split(","));
    }

    private static void validatePaginationParameterForSearchDC(UriInfo uriInfo) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        if (!queryParams.containsKey((Object)"startAt") && queryParams.containsKey((Object)"nextPageToken")) {
            String errorMessage = String.format("Parameter %s is not acceptable for Jira DC search API, use %s for pagination.", "nextPageToken", "startAt");
            throw new BadRequestException(errorMessage);
        }
    }

    private static void validatePaginationParameterForSearchCloud(UriInfo uriInfo) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        if (queryParams.containsKey((Object)"startAt") && !queryParams.containsKey((Object)"nextPageToken")) {
            String errorMessage = String.format("Parameter %s is deprecated for Jira Cloud search API, use %s for pagination.", "startAt", "nextPageToken");
            throw new BadRequestException(errorMessage);
        }
    }
}

