/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.internal.integration.jira.rest;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.internal.integration.jira.InternalJiraService;
import com.atlassian.internal.integration.jira.rest.RestUtils;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="/servers")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class JiraServerResource {
    private final InternalJiraService jiraService;

    @Inject
    public JiraServerResource(InternalJiraService jiraService) {
        this.jiraService = jiraService;
    }

    @GET
    @Path(value="/{applicationId}/projects/{project}/issue-types/{issueType}/fields-meta")
    public Response getIssueTypeMeta(@PathParam(value="applicationId") ApplicationId id, @PathParam(value="project") String project, @PathParam(value="issueType") int issueType) {
        return RestUtils.ok(this.jiraService.getIssueTypeMetaAsJson(id, project, issueType)).build();
    }

    @GET
    @Path(value="/{applicationId}/projects/{project}/issue-types")
    public Response getIssueTypes(@PathParam(value="applicationId") ApplicationId id, @PathParam(value="project") String project) {
        return RestUtils.ok(this.jiraService.getIssueTypesAsJson(id, project)).build();
    }

    @GET
    @Path(value="/{applicationId}/projects")
    public Response getProjectsMeta(@PathParam(value="applicationId") ApplicationId id) {
        return RestUtils.ok(this.jiraService.getProjectsAsJson(id)).build();
    }

    @GET
    public Response getServers() {
        return RestUtils.ok(this.jiraService.getServersAsJson()).build();
    }

    @GET
    @Path(value="/{applicationId}/features")
    public Response getFeatures(@PathParam(value="applicationId") ApplicationId id) {
        return RestUtils.ok(this.jiraService.getSupportedFeatures(id)).build();
    }
}

