/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.bitbucket.internal.webhook.event.AbstractAnalyticsWebhookTestedEvent;
import com.atlassian.bitbucket.internal.webhook.event.AnalyticsWebhookTestedErrorEvent;
import com.atlassian.bitbucket.internal.webhook.event.AnalyticsWebhookTestedFailedEvent;
import com.atlassian.bitbucket.internal.webhook.event.AnalyticsWebhookTestedSuccessEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.ProjectSupplier;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.webhook.WebhookScopeAdapter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookCallback;
import com.atlassian.webhooks.WebhookInvocation;
import com.atlassian.webhooks.WebhookRequestEnricher;
import com.atlassian.webhooks.diagnostics.WebhookDiagnosticsEvent;
import com.atlassian.webhooks.request.WebhookHttpRequest;
import com.atlassian.webhooks.request.WebhookHttpResponse;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.BiFunction;

public class AnalyticsWebhookTestedEnricher
implements WebhookRequestEnricher {
    private static final int WEIGHT = 1000;
    private final EventPublisher eventPublisher;
    private final ProjectSupplier projectSupplier;
    private final RepositorySupplier repositorySupplier;
    private final SecurityService securityServce;

    public AnalyticsWebhookTestedEnricher(@Nonnull EventPublisher eventPublisher, @Nonnull ProjectSupplier projectSupplier, @Nonnull RepositorySupplier repositorySupplier, @Nonnull SecurityService securityService) {
        this.eventPublisher = eventPublisher;
        this.projectSupplier = projectSupplier;
        this.repositorySupplier = repositorySupplier;
        this.securityServce = securityService;
    }

    public void enrich(@Nonnull WebhookInvocation invocation) {
        if (Objects.equals(invocation.getEvent(), WebhookDiagnosticsEvent.PING)) {
            invocation.registerCallback(new WebhookCallback(){

                public void onError(@Nonnull WebhookHttpRequest request, @Nonnull Throwable error, @Nonnull WebhookInvocation invocation) {
                    this.publish(invocation, (scope, url) -> new AnalyticsWebhookTestedErrorEvent((Scope)scope, (String)url));
                }

                public void onFailure(@Nonnull WebhookHttpRequest request, @Nonnull WebhookHttpResponse response, @Nonnull WebhookInvocation invocation) {
                    this.publish(invocation, (scope, url) -> new AnalyticsWebhookTestedFailedEvent((Scope)scope, (String)url, response.getStatusCode()));
                }

                public void onSuccess(@Nonnull WebhookHttpRequest request, @Nonnull WebhookHttpResponse response, @Nonnull WebhookInvocation invocation) {
                    this.publish(invocation, (scope, url) -> new AnalyticsWebhookTestedSuccessEvent((Scope)scope, (String)url, response.getStatusCode()));
                }

                private void publish(@Nonnull WebhookInvocation invocation, @Nonnull BiFunction<Scope, String, AbstractAnalyticsWebhookTestedEvent> eventFactoryFn) {
                    Webhook webhook = invocation.getWebhook();
                    Scope scope = (Scope)AnalyticsWebhookTestedEnricher.this.securityServce.withPermission(Permission.ADMIN, "Analytics").call(() -> WebhookScopeAdapter.adapt(AnalyticsWebhookTestedEnricher.this.projectSupplier, AnalyticsWebhookTestedEnricher.this.repositorySupplier, webhook.getScope()));
                    AbstractAnalyticsWebhookTestedEvent event = eventFactoryFn.apply(scope, webhook.getUrl());
                    AnalyticsWebhookTestedEnricher.this.eventPublisher.publish((Object)event);
                }
            });
        }
    }

    public int getWeight() {
        return 1000;
    }
}

