/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.webhooks.WebhookEvent;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum ApplicationWebhookEvent implements WebhookEvent
{
    MIRROR_REPOSITORY_SYNCHRONIZED("mirror:repo_synchronized"),
    PROJECT_CREATED("project:created"),
    PROJECT_DELETED("project:deleted"),
    PROJECT_MODIFIED("project:modified"),
    REPOSITORY_CREATED("repo:created"),
    REPOSITORY_FORKED("repo:forked"),
    REPOSITORY_DELETED("repo:deleted"),
    REPOSITORY_MODIFIED("repo:modified"),
    REPOSITORY_REFS_CHANGED("repo:refs_changed"),
    REPOSITORY_DEFAULT_BRANCH_MODIFIED("repo:default_branch_modified"),
    REPOSITORY_SECRET_DETECTED("repo:secret_detected"),
    REPOSITORY_COMMENT_ADDED("repo:comment:added"),
    REPOSITORY_COMMENT_EDITED("repo:comment:edited"),
    REPOSITORY_COMMENT_DELETED("repo:comment:deleted"),
    PR_OPENED("pr:opened"),
    PR_FROM_REF_UPDATED("pr:from_ref_updated"),
    PR_TO_REF_UPDATED("pr:to_ref_updated"),
    PR_MERGED("pr:merged"),
    PR_DECLINED("pr:declined"),
    PR_DELETED("pr:deleted"),
    PR_MODIFIED("pr:modified"),
    PR_REVIEWER_UPDATED("pr:reviewer:updated"),
    PR_REVIEWER_STATUS_APPROVED("pr:reviewer:approved"),
    PR_REVIEWER_STATUS_UNAPPROVED("pr:reviewer:unapproved"),
    PR_REVIEWER_STATUS_NEEDS_WORK("pr:reviewer:needs_work"),
    PR_COMMENT_ADDED("pr:comment:added"),
    PR_COMMENT_EDITED("pr:comment:edited"),
    PR_COMMENT_DELETED("pr:comment:deleted");

    private static final String I18N_PREFIX = "bitbucket.webhooks.event.";
    private final String id;
    private final String i18nKey;

    private ApplicationWebhookEvent(String id) {
        this.id = id;
        this.i18nKey = I18N_PREFIX + this.name().toLowerCase();
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getI18nKey() {
        return this.i18nKey;
    }

    @Nullable
    public static ApplicationWebhookEvent forId(@Nullable String id) {
        for (ApplicationWebhookEvent event : ApplicationWebhookEvent.values()) {
            if (!event.getId().equalsIgnoreCase(id)) continue;
            return event;
        }
        return null;
    }
}

