/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretsDetectedEvent;
import com.atlassian.bitbucket.dmz.webhook.MirrorScope;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentAddedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentDeletedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentEditedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentRepliedEvent;
import com.atlassian.bitbucket.event.mirror.RepositoryMirrorEvent;
import com.atlassian.bitbucket.event.mirror.RepositoryMirrorSynchronizedEvent;
import com.atlassian.bitbucket.event.project.ProjectCreatedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.project.ProjectEvent;
import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentAddedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentEditedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentRepliedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantApprovedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantReviewedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantUnapprovedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReopenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDefaultBranchModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.event.repository.RepositoryForkedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.internal.webhook.ApplicationWebhookEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalRepositoryWebhookRefsChangedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.webhook.WebhookScopeAdapter;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookPublishRequest;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.WebhookService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationWebhookEventDispatcher {
    @VisibleForTesting
    static final int DEFAULT_COMMITS_LIMIT = 5;
    @VisibleForTesting
    static final String PLUGIN_PROPERTY_COMMITS_LIMIT = "plugin.webhooks.push.event.commits.limit";
    @VisibleForTesting
    static final String WEBHOOKS_PR_TO_REF_UPDATED_EVENT_FEATURE_FLAG = "webhooks.pullrequest.torefupdated.event";
    private static final Logger log = LoggerFactory.getLogger(ApplicationWebhookEventDispatcher.class);
    private final int commitsLimit;
    private final CommitService commitService;
    private final DarkFeatureManager darkFeatureManager;
    private final WebhookService webhookService;

    public ApplicationWebhookEventDispatcher(ApplicationPropertiesService applicationPropertiesService, CommitService commitService, DarkFeatureManager darkFeatureManager, WebhookService webhookService) {
        this.commitService = commitService;
        this.darkFeatureManager = darkFeatureManager;
        this.webhookService = webhookService;
        this.commitsLimit = applicationPropertiesService.getPluginProperty(PLUGIN_PROPERTY_COMMITS_LIMIT, 5);
    }

    @EventListener
    public void onCommitCommentAdded(CommitDiscussionCommentAddedEvent event) {
        this.publishForRepository(ApplicationWebhookEvent.REPOSITORY_COMMENT_ADDED, (RepositoryEvent)event, new WebhookScope[0]);
    }

    @EventListener
    public void onCommitCommentDeleted(CommitDiscussionCommentDeletedEvent event) {
        this.publishForRepository(ApplicationWebhookEvent.REPOSITORY_COMMENT_DELETED, (RepositoryEvent)event, new WebhookScope[0]);
    }

    @EventListener
    public void onCommitCommentEdited(CommitDiscussionCommentEditedEvent event) {
        this.publishForRepository(ApplicationWebhookEvent.REPOSITORY_COMMENT_EDITED, (RepositoryEvent)event, new WebhookScope[0]);
    }

    @EventListener
    public void onCommitCommentReplied(CommitDiscussionCommentRepliedEvent event) {
        this.publishForRepository(ApplicationWebhookEvent.REPOSITORY_COMMENT_ADDED, (RepositoryEvent)event, new WebhookScope[0]);
    }

    @EventListener
    public void onProjectCreated(ProjectCreatedEvent event) {
        this.publishForProject(ApplicationWebhookEvent.PROJECT_CREATED, (ProjectEvent)event);
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.publishForProject(ApplicationWebhookEvent.PROJECT_DELETED, (ProjectEvent)event);
    }

    @EventListener
    public void onProjectModified(ProjectModifiedEvent event) {
        this.publishForProject(ApplicationWebhookEvent.PROJECT_MODIFIED, (ProjectEvent)event);
    }

    @EventListener
    public void onPullRequestCommentAdded(PullRequestCommentAddedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_COMMENT_ADDED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestCommentDeleted(PullRequestCommentDeletedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_COMMENT_DELETED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestCommentEdited(PullRequestCommentEditedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_COMMENT_EDITED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestCommentReplied(PullRequestCommentRepliedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_COMMENT_ADDED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestDeclined(PullRequestDeclinedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_DECLINED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestDeleted(PullRequestDeletedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_DELETED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_MERGED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_OPENED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestParticipantReviewed(PullRequestParticipantReviewedEvent event) {
        ApplicationWebhookEvent webhookEvent = event instanceof PullRequestParticipantApprovedEvent ? ApplicationWebhookEvent.PR_REVIEWER_STATUS_APPROVED : ApplicationWebhookEvent.PR_REVIEWER_STATUS_NEEDS_WORK;
        this.publishForPullRequest(webhookEvent, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestParticipantUnapproved(PullRequestParticipantUnapprovedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_REVIEWER_STATUS_UNAPPROVED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestReopened(PullRequestReopenedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_OPENED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent event) {
        if (event.isFromHashUpdated()) {
            this.publishForPullRequest(ApplicationWebhookEvent.PR_FROM_REF_UPDATED, (PullRequestEvent)event);
        } else if (event.isToHashUpdated() && this.darkFeatureManager.isEnabledForAllUsers(WEBHOOKS_PR_TO_REF_UPDATED_EVENT_FEATURE_FLAG).orElse(Boolean.FALSE).booleanValue()) {
            this.publishForPullRequest(ApplicationWebhookEvent.PR_TO_REF_UPDATED, (PullRequestEvent)event);
        }
    }

    @EventListener
    public void onPullRequestReviewersUpdated(PullRequestReviewersUpdatedEvent event) {
        this.publishForPullRequest(ApplicationWebhookEvent.PR_REVIEWER_UPDATED, (PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestUpdated(PullRequestUpdatedEvent event) {
        if (!(Objects.equals(event.getPreviousTitle(), event.getPullRequest().getTitle()) && Objects.equals(event.getPreviousDescription(), event.getPullRequest().getDescription()) && Objects.isNull(event.getPreviousToBranch()) && Objects.equals(event.isPreviousDraft(), event.getPullRequest().isDraft()))) {
            this.publishForPullRequest(ApplicationWebhookEvent.PR_MODIFIED, (PullRequestEvent)event);
        }
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        Collection refChanges = event.getRefChanges();
        Repository repository = event.getRepository();
        ApplicationUser user = event.getUser();
        if (!refChanges.isEmpty()) {
            refChanges.forEach(refChange -> {
                List<Commit> commits = this.getCommits((RefChange)refChange, repository);
                Commit toCommit = this.getToCommit((RefChange)refChange, repository);
                this.publishForRepositoryRefsChanged(ApplicationWebhookEvent.REPOSITORY_REFS_CHANGED, (RepositoryRefsChangedEvent)new InternalRepositoryWebhookRefsChangedEvent(this, repository, Collections.singleton(refChange), commits, toCommit, user));
            });
        } else {
            this.publishForRepositoryRefsChanged(ApplicationWebhookEvent.REPOSITORY_REFS_CHANGED, (RepositoryRefsChangedEvent)new InternalRepositoryWebhookRefsChangedEvent(this, repository, refChanges, Collections.emptyList(), null, user));
        }
    }

    @EventListener
    public void onRepositoryCreated(RepositoryCreatedEvent event) {
        this.publishForRepository(ApplicationWebhookEvent.REPOSITORY_CREATED, (RepositoryEvent)event, MirrorScope.MIRROR);
    }

    @EventListener
    public void onRepositoryDefaultBranchModified(RepositoryDefaultBranchModifiedEvent event) {
        this.publishForRepository(ApplicationWebhookEvent.REPOSITORY_DEFAULT_BRANCH_MODIFIED, (RepositoryEvent)event, MirrorScope.MIRROR);
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.publishForRepository(ApplicationWebhookEvent.REPOSITORY_DELETED, (RepositoryEvent)event, MirrorScope.MIRROR);
    }

    @EventListener
    public void onRepositoryForked(RepositoryForkedEvent event) {
        this.publishForRepository(ApplicationWebhookEvent.REPOSITORY_FORKED, (RepositoryEvent)event, new WebhookScope[0]);
    }

    @EventListener
    public void onRepositoryMirrorSynchronizedEvent(RepositoryMirrorSynchronizedEvent event) {
        this.publishForMirrorRepository(ApplicationWebhookEvent.MIRROR_REPOSITORY_SYNCHRONIZED, (RepositoryMirrorEvent)event);
    }

    @EventListener
    public void onRepositoryModified(RepositoryModifiedEvent event) {
        if (event.isOriginChanged() || event.isNameChanged() || event.isSlugChanged() || event.isMoved() || this.isPublicChanged(event)) {
            this.publishForRepository(ApplicationWebhookEvent.REPOSITORY_MODIFIED, (RepositoryEvent)event, MirrorScope.MIRROR);
        }
    }

    @EventListener
    public void onSecretDetectedEvent(SecretsDetectedEvent event) {
        log.trace("Publishing webhook event {} for repository event [{}]", (Object)ApplicationWebhookEvent.REPOSITORY_SECRET_DETECTED.getId(), (Object)event.toString());
        this.webhookService.publish(WebhookPublishRequest.builder((WebhookEvent)ApplicationWebhookEvent.REPOSITORY_SECRET_DETECTED, (Object)event, this.getUrlReplacements(event)).eventScope(WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository()))).scopes(WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)event.getRepository().getProject())), new WebhookScope[]{WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository())), WebhookScope.GLOBAL}).build());
    }

    private void addIfNotBlank(ImmutableList.Builder<String> builder, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            builder.add((Object)value);
        }
    }

    private List<Commit> getCommits(RefChange refChange, Repository repository) {
        if (refChange == null) {
            return Collections.emptyList();
        }
        CommitsBetweenRequest.Builder commitsRequestBuilder = new CommitsBetweenRequest.Builder(repository);
        ImmutableList.Builder builder = ImmutableList.builder();
        switch (refChange.getType()) {
            case ADD: {
                commitsRequestBuilder.include(refChange.getToHash(), new String[0]);
                this.addIfNotBlank((ImmutableList.Builder<String>)builder, refChange.getToHash());
                break;
            }
            case DELETE: {
                commitsRequestBuilder.exclude(refChange.getFromHash(), new String[0]);
                break;
            }
            case UPDATE: {
                commitsRequestBuilder.include(refChange.getToHash(), new String[0]);
                commitsRequestBuilder.exclude(refChange.getFromHash(), new String[0]);
                this.addIfNotBlank((ImmutableList.Builder<String>)builder, refChange.getToHash());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected RefChangeType: " + String.valueOf(refChange.getType()));
            }
        }
        try {
            return builder.build().isEmpty() ? Collections.emptyList() : this.commitService.getCommitsBetween(commitsRequestBuilder.build(), PageUtils.newRequest((int)0, (int)this.commitsLimit)).stream().collect(Collectors.toList());
        }
        catch (NoSuchCommitException e) {
            log.warn("{}: Failed to enrich webhook with commits for ref change {}.", new Object[]{repository, refChange, e});
            return Collections.emptyList();
        }
    }

    private Commit getToCommit(RefChange refChange, Repository repository) {
        try {
            if (refChange != null && refChange.getType() != RefChangeType.DELETE) {
                String commitId = StringUtils.trimToNull((String)refChange.getToHash());
                return commitId == null ? null : this.commitService.getCommit(new CommitRequest.Builder(repository, commitId).build());
            }
        }
        catch (NoSuchCommitException e) {
            log.warn("{}: Failed to enrich webhook with commit for ref change {}.", new Object[]{repository, refChange, e});
        }
        return null;
    }

    private boolean isPublicChanged(RepositoryModifiedEvent event) {
        return event.getOldValue().isPublic() != event.getNewValue().isPublic();
    }

    private void publishForMirrorRepository(WebhookEvent webhookEvent, RepositoryMirrorEvent event) {
        log.trace("Publishing webhook event {} for repository mirror event [{}]", (Object)webhookEvent.getId(), (Object)event);
        this.webhookService.publish(WebhookPublishRequest.builder((WebhookEvent)webhookEvent, (Object)event, this.getUrlReplacements(event)).eventScope(WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository()))).scopes(WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)event.getRepository().getProject())), new WebhookScope[]{WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository())), WebhookScope.GLOBAL}).build());
    }

    private void publishForProject(WebhookEvent webhookEvent, ProjectEvent event) {
        log.trace("Publishing webhook event {} for project event [{}]", (Object)webhookEvent.getId(), (Object)event.toString());
        this.webhookService.publish(WebhookPublishRequest.builder((WebhookEvent)webhookEvent, (Object)event, this.getUrlReplacements(event)).eventScope(WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)event.getProject()))).scopes(WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)event.getProject())), new WebhookScope[]{WebhookScope.GLOBAL, MirrorScope.MIRROR}).build());
    }

    private void publishForPullRequest(WebhookEvent webhookEvent, PullRequestEvent event) {
        log.trace("Publishing webhook event {} for repository event [{}]", (Object)webhookEvent.getId(), (Object)event.toString());
        Repository repository = event.getPullRequest().getToRef().getRepository();
        this.webhookService.publish(WebhookPublishRequest.builder((WebhookEvent)webhookEvent, (Object)event, this.getUrlReplacements(event)).eventScope(WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)repository))).scopes(WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)repository.getProject())), new WebhookScope[]{WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)repository)), WebhookScope.GLOBAL}).build());
    }

    private void publishForRepository(WebhookEvent webhookEvent, RepositoryEvent event, WebhookScope ... additionalScopes) {
        Repository origin;
        log.trace("Publishing webhook event {} for repository event [{}]", (Object)webhookEvent.getId(), (Object)event.toString());
        ImmutableList scopes = new ImmutableList.Builder().add((Object)WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository()))).add((Object)WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)event.getRepository().getProject()))).add((Object[])additionalScopes).build();
        WebhookPublishRequest.SearchBuilder builder = WebhookPublishRequest.builder((WebhookEvent)webhookEvent, (Object)event, this.getUrlReplacements(event)).eventScope(WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository()))).scopes(WebhookScope.GLOBAL, (WebhookScope[])scopes.toArray((Object[])new WebhookScope[0]));
        if (event instanceof RepositoryModifiedEvent && ((RepositoryModifiedEvent)event).isMoved()) {
            builder = builder.scopes(WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)((RepositoryModifiedEvent)event).getOldValue().getProject())), new WebhookScope[0]);
        }
        if (event instanceof RepositoryForkedEvent && (origin = event.getRepository().getOrigin()) != null) {
            builder = WebhookPublishRequest.builder((WebhookEvent)webhookEvent, (Object)event, this.getUrlReplacements(event)).eventScope(WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository()))).scopes(WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)origin.getProject())), new WebhookScope[]{WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)origin))}).scopes(WebhookScope.GLOBAL, additionalScopes);
        }
        this.webhookService.publish(builder.build());
    }

    private void publishForRepositoryRefsChanged(WebhookEvent webhookEvent, RepositoryRefsChangedEvent event) {
        log.trace("Publishing webhook event {} for repository event [{}]", (Object)webhookEvent.getId(), (Object)event.toString());
        this.webhookService.publish(WebhookPublishRequest.builder((WebhookEvent)webhookEvent, (Object)event, this.getUrlReplacements(event)).eventScope(WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository()))).scopes(WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)event.getRepository().getProject())), new WebhookScope[]{WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository())), WebhookScope.GLOBAL, MirrorScope.MIRROR}).build());
    }

    private Project getProjectFromPayload(Object payload) {
        if (payload instanceof ProjectEvent) {
            ProjectEvent projectEvent = (ProjectEvent)payload;
            return projectEvent.getProject();
        }
        if (payload instanceof RepositoryEvent) {
            RepositoryEvent repositoryEvent = (RepositoryEvent)payload;
            return repositoryEvent.getRepository().getProject();
        }
        if (payload instanceof RepositoryMirrorSynchronizedEvent) {
            RepositoryMirrorSynchronizedEvent repositoryMirrorSynchronizedEvent = (RepositoryMirrorSynchronizedEvent)payload;
            return repositoryMirrorSynchronizedEvent.getRepository().getProject();
        }
        if (payload instanceof RepositoryRefsChangedEvent) {
            RepositoryRefsChangedEvent repositoryRefsChangedEvent = (RepositoryRefsChangedEvent)payload;
            return repositoryRefsChangedEvent.getRepository().getProject();
        }
        if (payload instanceof PullRequestEvent) {
            PullRequestEvent pullRequestEvent = (PullRequestEvent)payload;
            return pullRequestEvent.getPullRequest().getFromRef().getRepository().getProject();
        }
        return null;
    }

    private PullRequest getPullRequestFromPayload(Object payload) {
        if (payload instanceof PullRequestEvent) {
            PullRequestEvent pullRequestEvent = (PullRequestEvent)payload;
            return pullRequestEvent.getPullRequest();
        }
        return null;
    }

    private Repository getRepositoryFromPayload(Object payload) {
        if (payload instanceof RepositoryEvent) {
            RepositoryEvent repositoryEvent = (RepositoryEvent)payload;
            return repositoryEvent.getRepository();
        }
        if (payload instanceof RepositoryMirrorSynchronizedEvent) {
            RepositoryMirrorSynchronizedEvent repositoryMirrorSynchronizedEvent = (RepositoryMirrorSynchronizedEvent)payload;
            return repositoryMirrorSynchronizedEvent.getRepository();
        }
        if (payload instanceof RepositoryRefsChangedEvent) {
            RepositoryRefsChangedEvent repositoryRefsChangedEvent = (RepositoryRefsChangedEvent)payload;
            return repositoryRefsChangedEvent.getRepository();
        }
        if (payload instanceof PullRequestEvent) {
            PullRequestEvent pullRequestEvent = (PullRequestEvent)payload;
            return pullRequestEvent.getPullRequest().getFromRef().getRepository();
        }
        return null;
    }

    private Map<String, Object> getUrlReplacements(Object payload) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        Project project = this.getProjectFromPayload(payload);
        Repository repository = this.getRepositoryFromPayload(payload);
        PullRequest pullRequest = this.getPullRequestFromPayload(payload);
        if (project != null) {
            builder.put((Object)"project.key", (Object)project.getKey());
        }
        if (repository != null) {
            RepositoryRefsChangedEvent repositoryRefsChangedEvent;
            RefChange refChange;
            builder.put((Object)"repo.slug", (Object)repository.getSlug());
            if (payload instanceof RepositoryRefsChangedEvent && (refChange = (RefChange)Iterables.getFirst((Iterable)(repositoryRefsChangedEvent = (RepositoryRefsChangedEvent)payload).getRefChanges(), null)) != null) {
                builder.put((Object)"repo.ref.branchName", (Object)refChange.getRef().getDisplayId());
            }
        }
        if (pullRequest != null) {
            builder.put((Object)"pr.fromRef.branchName", (Object)pullRequest.getFromRef().getDisplayId());
            builder.put((Object)"pr.toRef.branchName", (Object)pullRequest.getToRef().getDisplayId());
        }
        return builder.build();
    }
}

