/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.bitbucket.internal.webhook.ApplicationWebhookEvent;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookEventProvider;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ApplicationWebhookEventProvider
implements WebhookEventProvider {
    private static final List<WebhookEvent> EVENTS = ImmutableList.copyOf((Object[])ApplicationWebhookEvent.values());
    private static final List<WebhookEvent> EVENTS_WITHOUT_TO_REF_UPDATED = ImmutableList.copyOf((Collection)Arrays.stream(ApplicationWebhookEvent.values()).filter(e -> e != ApplicationWebhookEvent.PR_TO_REF_UPDATED).collect(Collectors.toList()));
    private final DarkFeatureManager darkFeatureManager;

    public ApplicationWebhookEventProvider(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public WebhookEvent forId(@Nonnull String id) {
        for (WebhookEvent event : this.getEvents()) {
            if (!event.getId().equalsIgnoreCase(id)) continue;
            return event;
        }
        return null;
    }

    @Nonnull
    public List<WebhookEvent> getEvents() {
        if (this.isToRefUpdatedEventEnabled()) {
            return EVENTS;
        }
        return EVENTS_WITHOUT_TO_REF_UPDATED;
    }

    public int getWeight() {
        return 10;
    }

    private boolean isToRefUpdatedEventEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers("webhooks.pullrequest.torefupdated.event").orElse(Boolean.FALSE);
    }
}

