/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.bitbucket.internal.webhook.ApplicationWebhookEvent;
import com.atlassian.bitbucket.internal.webhook.json.WebhookJsonRenderer;
import com.atlassian.webhooks.WebhookEvent;
import com.atlassian.webhooks.WebhookInvocation;
import com.atlassian.webhooks.WebhookPayloadBuilder;
import com.atlassian.webhooks.WebhookPayloadProvider;
import com.google.common.net.MediaType;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;

public class ApplicationWebhookPayloadProvider
implements WebhookPayloadProvider {
    private static final byte[] EMPTY_BODY = new byte[0];
    private final WebhookJsonRenderer renderer;

    public ApplicationWebhookPayloadProvider(WebhookJsonRenderer renderer) {
        this.renderer = renderer;
    }

    public void setPayload(@Nonnull WebhookInvocation invocation, @Nonnull WebhookPayloadBuilder builder) {
        WebhookEvent event = invocation.getEvent();
        if (event instanceof ApplicationWebhookEvent) {
            byte[] body = invocation.getPayload().map(payload -> this.renderer.render((ApplicationWebhookEvent)event, payload)).map(bodyString -> bodyString.getBytes(StandardCharsets.UTF_8)).orElse(EMPTY_BODY);
            builder.body(body, MediaType.JSON_UTF_8.toString());
        }
    }

    public boolean supports(@Nonnull WebhookInvocation invocation) {
        return invocation.getEvent() instanceof ApplicationWebhookEvent;
    }

    public int getWeight() {
        return 100;
    }
}

