/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.bitbucket.internal.webhook.InternalWebhooksConfiguration;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.webhooks.WebhooksConfiguration;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ConfigurableWebhooksConfiguration
implements InternalWebhooksConfiguration {
    private static final WebhooksConfiguration DEFAULT = new WebhooksConfiguration(){};
    private static final String PREFIX = "plugin.webhooks.";
    private final ApplicationPropertiesService propertiesService;

    public ConfigurableWebhooksConfiguration(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    public double getBackoffExponent() {
        return this.getDouble("http.backoff.interval.exponent", DEFAULT.getBackoffExponent());
    }

    @Nonnull
    public Duration getBackoffInitialDelay() {
        return Duration.of(this.getLong("http.backoff.interval.initial", DEFAULT.getBackoffInitialDelay().get(ChronoUnit.SECONDS)), ChronoUnit.SECONDS);
    }

    @Nonnull
    public Duration getBackoffMaxDelay() {
        return Duration.of(this.getLong("http.backoff.interval.max", DEFAULT.getBackoffMaxDelay().get(ChronoUnit.SECONDS)), ChronoUnit.SECONDS);
    }

    public int getBackoffTriggerCount() {
        return this.getInt("http.backoff.trigger.count", DEFAULT.getBackoffTriggerCount());
    }

    @Nonnull
    public List<String> getBlacklistedAddresses() {
        String blacklist = this.propertiesService.getPluginProperty("plugin.webhooks.http.ip.blacklist", null);
        if (blacklist == null) {
            return DEFAULT.getBlacklistedAddresses();
        }
        return Arrays.stream(blacklist.split(",")).map(String::trim).collect(Collectors.toList());
    }

    @Nonnull
    public Duration getConnectionTimeout() {
        return Duration.of(this.getLong("connection.timeout", DEFAULT.getConnectionTimeout().toMillis()), ChronoUnit.MILLIS);
    }

    public int getDispatchQueueSize() {
        return this.getInt("dispatch.queue.size", DEFAULT.getDispatchQueueSize());
    }

    @Nonnull
    public Duration getDispatchTimeout() {
        return Duration.of(this.getLong("dispatch.queue.timeout", DEFAULT.getDispatchTimeout().toMillis()), ChronoUnit.MILLIS);
    }

    @Override
    @Nonnull
    public String getHubSignatureAlgorithm() {
        return this.getString("signature.algorithm", "sha256");
    }

    public int getIoThreadCount() {
        return this.getInt("io.threads", DEFAULT.getIoThreadCount());
    }

    public int getMaxCallbackThreads() {
        return this.getInt("callback.thread.count", DEFAULT.getMaxCallbackThreads());
    }

    public int getMaxHttpConnections() {
        return this.getInt("http.connection.max", DEFAULT.getMaxHttpConnections());
    }

    public int getMaxHttpConnectionsPerHost() {
        return this.getInt("http.connection.host.max", DEFAULT.getMaxHttpConnectionsPerHost());
    }

    public int getMaxInFlightDispatches() {
        return this.getInt("dispatch.inflight.max", DEFAULT.getMaxInFlightDispatches());
    }

    public long getMaxResponseBodySize() {
        return this.getLong("response.http.body.size.max", DEFAULT.getMaxResponseBodySize());
    }

    public int getMaxResponseHeaderLineSize() {
        return this.getInt("response.header.line.size.max", DEFAULT.getMaxResponseHeaderLineSize());
    }

    @Nonnull
    public Duration getSocketTimeout() {
        return Duration.of(this.getLong("socket.timeout", DEFAULT.getSocketTimeout().toMillis()), ChronoUnit.MILLIS);
    }

    public boolean isInvocationHistoryEnabled() {
        return true;
    }

    private double getDouble(String key, double defaultValue) {
        return this.propertiesService.getPluginProperty(PREFIX + key, defaultValue);
    }

    private int getInt(String key, int defaultValue) {
        return this.propertiesService.getPluginProperty(PREFIX + key, defaultValue);
    }

    private long getLong(String key, long defaultValue) {
        return this.propertiesService.getPluginProperty(PREFIX + key, defaultValue);
    }

    private String getString(String key, String defaultValue) {
        return this.propertiesService.getPluginProperty(PREFIX + key, defaultValue);
    }
}

