/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.dmz.discovery.DiscoverableFeature;
import com.atlassian.bitbucket.dmz.discovery.FeatureDiscoveryService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.webhook.ApplicationWebhookEvent;
import com.atlassian.bitbucket.project.ProjectSupplier;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@LicensedOnly
public class ConfigurationServlet
extends HttpServlet {
    private static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-webhooks:webhook-page-templates";
    private static final String TEMPLATE_KEY = "bitbucketPluginWebhooks.internal.views.pages.webhookSettings.settings";
    private final FeatureDiscoveryService featureDiscoveryService;
    private final I18nService i18nService;
    private final RepositorySupplier repositorySupplier;
    private final ProjectSupplier projectSupplier;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public ConfigurationServlet(FeatureDiscoveryService featureDiscoveryService, I18nService i18nService, RepositorySupplier repositorySupplier, ProjectSupplier projectSupplier, SoyTemplateRenderer soyTemplateRenderer) {
        this.featureDiscoveryService = featureDiscoveryService;
        this.i18nService = i18nService;
        this.repositorySupplier = repositorySupplier;
        this.projectSupplier = projectSupplier;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Optional<Scope> scope = this.getScope(req.getPathInfo());
        if (scope.isPresent()) {
            if (!(scope.get() instanceof RepositoryScope) && !(scope.get() instanceof ProjectScope)) {
                resp.sendError(404);
                return;
            }
            final HashMap<String, Object> context = new HashMap<String, Object>();
            this.putI18nStrings(context);
            scope.get().accept((ScopeVisitor)new ScopeVisitor<Void>(){

                public Void visit(@Nonnull ProjectScope scope) {
                    context.put("project", scope.getProject());
                    context.put("scopeType", scope.getType());
                    ConfigurationServlet.this.featureDiscoveryService.setDiscovered(EnumSet.of(DiscoverableFeature.WEBHOOKS));
                    return null;
                }

                public Void visit(@Nonnull RepositoryScope scope) {
                    context.put("project", scope.getProject());
                    context.put("repository", scope.getRepository());
                    context.put("scopeType", scope.getType());
                    return null;
                }
            });
            try {
                resp.setContentType("text/html;charset=UTF-8");
                this.soyTemplateRenderer.render((Appendable)resp.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, context);
            }
            catch (SoyException soyException) {
                this.handleSoyError(soyException);
            }
        } else {
            resp.sendError(404);
        }
    }

    private Optional<Scope> getScope(String pathInfo) {
        if (Strings.isNullOrEmpty((String)pathInfo)) {
            return Optional.empty();
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        if (pathParts.length < 2) {
            return Optional.empty();
        }
        if (pathParts.length >= 4 && pathParts[2].equals("repos")) {
            return Optional.ofNullable(this.repositorySupplier.getBySlug(pathParts[1], pathParts[3])).map(Scopes::repository);
        }
        return Optional.ofNullable(this.projectSupplier.getByKey(pathParts[1])).map(Scopes::project);
    }

    private void handleSoyError(SoyException soyException) {
        throw soyException;
    }

    private void putI18nStrings(Map<String, Object> context) {
        context.put("translations", Arrays.stream(ApplicationWebhookEvent.values()).collect(Collectors.toMap(ApplicationWebhookEvent::getId, event -> this.i18nService.getMessage(event.getI18nKey(), new Object[0]))));
    }
}

