/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.bitbucket.internal.webhook.event.InternalProjectWebhookCreatedEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalProjectWebhookDeletedEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalProjectWebhookModifiedEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalRepositoryWebhookCreatedEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalRepositoryWebhookDeletedEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalRepositoryWebhookModifiedEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalWebhookStatisticsEvent;
import com.atlassian.bitbucket.project.ProjectSupplier;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.webhook.WebhookScopeAdapter;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.webhooks.WebhookService;
import com.atlassian.webhooks.WebhookStatistics;
import com.atlassian.webhooks.event.WebhookCreatedEvent;
import com.atlassian.webhooks.event.WebhookDeletedEvent;
import com.atlassian.webhooks.event.WebhookModifiedEvent;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookAnalyticsService
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(WebhookAnalyticsService.class);
    private static final JobId JOB_ID = JobId.of((String)WebhookAnalyticsJobRunner.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)WebhookAnalyticsJobRunner.class.getName());
    private static final String SCOPE_PROJECT = "project";
    private static final String SCOPE_REPOSITORY = "repository";
    private final EventPublisher eventPublisher;
    private final ProjectSupplier projectSupplier;
    private final RepositorySupplier repositorySupplier;
    private final SchedulerService schedulerService;
    private final WebhookService webhookService;

    public WebhookAnalyticsService(@Nonnull EventPublisher eventPublisher, @Nonnull ProjectSupplier projectSupplier, @Nonnull RepositorySupplier repositorySupplier, @Nonnull SchedulerService schedulerService, @Nonnull WebhookService webhookService) {
        this.eventPublisher = eventPublisher;
        this.projectSupplier = projectSupplier;
        this.repositorySupplier = repositorySupplier;
        this.schedulerService = schedulerService;
        this.webhookService = webhookService;
    }

    public void onStart() {
        long firstRunTime = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(30L);
        long intervalInMillis = TimeUnit.DAYS.toMillis(1L);
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new WebhookAnalyticsJobRunner());
        try {
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withSchedule(Schedule.forInterval((long)intervalInMillis, (Date)new Date(firstRunTime))).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER));
        }
        catch (SchedulerServiceException e) {
            log.error("Could not schedule daily webhook analytics job", (Throwable)e);
        }
    }

    public void onStop() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @EventListener
    public void onWebhookCreated(@Nonnull WebhookCreatedEvent event) {
        String scope = event.getWebhook().getScope().getType();
        if (scope.equals(SCOPE_REPOSITORY)) {
            this.eventPublisher.publish((Object)new InternalRepositoryWebhookCreatedEvent(this, WebhookScopeAdapter.adapt(this.projectSupplier, this.repositorySupplier, event.getWebhook().getScope()), event.getWebhook()));
        } else if (scope.equals(SCOPE_PROJECT)) {
            this.eventPublisher.publish((Object)new InternalProjectWebhookCreatedEvent(this, WebhookScopeAdapter.adapt(this.projectSupplier, this.repositorySupplier, event.getWebhook().getScope()), event.getWebhook()));
        }
    }

    @EventListener
    public void onWebhookModified(@Nonnull WebhookModifiedEvent event) {
        String scope = event.getNewValue().getScope().getType();
        if (scope.equals(SCOPE_REPOSITORY)) {
            this.eventPublisher.publish((Object)new InternalRepositoryWebhookModifiedEvent(this, WebhookScopeAdapter.adapt(this.projectSupplier, this.repositorySupplier, event.getNewValue().getScope()), event.getOldValue(), event.getNewValue()));
        } else if (scope.equals(SCOPE_PROJECT)) {
            this.eventPublisher.publish((Object)new InternalProjectWebhookModifiedEvent(this, WebhookScopeAdapter.adapt(this.projectSupplier, this.repositorySupplier, event.getNewValue().getScope()), event.getOldValue(), event.getNewValue()));
        }
    }

    @EventListener
    public void onWebhookDeleted(@Nonnull WebhookDeletedEvent event) {
        String scope = event.getWebhook().getScope().getType();
        if (scope.equals(SCOPE_REPOSITORY)) {
            this.eventPublisher.publish((Object)new InternalRepositoryWebhookDeletedEvent(this, WebhookScopeAdapter.adapt(this.projectSupplier, this.repositorySupplier, event.getWebhook().getScope()), event.getWebhook()));
        } else if (scope.equals(SCOPE_PROJECT)) {
            this.eventPublisher.publish((Object)new InternalProjectWebhookDeletedEvent(this, WebhookScopeAdapter.adapt(this.projectSupplier, this.repositorySupplier, event.getWebhook().getScope()), event.getWebhook()));
        }
    }

    private void onWebhookStatisticsSummary() {
        this.webhookService.getStatistics().ifPresent(statistics -> this.eventPublisher.publish((Object)new InternalWebhookStatisticsEvent((WebhookStatistics)statistics)));
    }

    private class WebhookAnalyticsJobRunner
    implements JobRunner {
        private WebhookAnalyticsJobRunner() {
        }

        public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
            WebhookAnalyticsService.this.onWebhookStatisticsSummary();
            return JobRunnerResponse.success();
        }
    }
}

