/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.bitbucket.internal.webhook.InternalWebhooksConfiguration;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookInvocation;
import com.atlassian.webhooks.WebhookRequestEnricher;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookBodySigner
implements WebhookRequestEnricher {
    private static final Logger log = LoggerFactory.getLogger(WebhookBodySigner.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String SIGNATURE_HEADER = "X-Hub-Signature";
    private static final int WEIGHT = 1000;
    private final InternalWebhooksConfiguration config;

    public WebhookBodySigner(InternalWebhooksConfiguration config) {
        this.config = config;
    }

    public void enrich(@Nonnull WebhookInvocation webhookInvocation) {
        Webhook webhook = webhookInvocation.getWebhook();
        String secret = (String)webhook.getConfiguration().get("secret");
        if (StringUtils.isNotEmpty((CharSequence)secret)) {
            this.signBody(webhookInvocation, secret);
        } else if (secret != null) {
            log.warn("Secret provided to webhook signature provider is an empty string and will be ignored for invocation [{}]", (Object)webhookInvocation.getId());
        }
        webhook.getCredentials().ifPresent(credentials -> {
            String username = credentials.getUsername().orElse("");
            String password = credentials.getPassword().orElse("");
            String authToken = username + ":" + password;
            webhookInvocation.getRequestBuilder().header(AUTHORIZATION_HEADER, "Basic " + Base64.getEncoder().encodeToString(authToken.getBytes(StandardCharsets.UTF_8)));
        });
    }

    public int getWeight() {
        return 1000;
    }

    private void signBody(@Nonnull WebhookInvocation webhookInvocation, String secret) {
        String algorithm = this.config.getHubSignatureAlgorithm();
        String algorithmHmacName = "Hmac" + algorithm.toUpperCase();
        String algorithmDigestPrefix = algorithm.toLowerCase() + "=";
        byte[] body = webhookInvocation.getRequestBuilder().getBody();
        try {
            Mac mac = Mac.getInstance(algorithmHmacName);
            byte[] keyBytes = secret.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, algorithmHmacName);
            mac.init(keySpec);
            byte[] digest = mac.doFinal(body);
            String digestString = Hex.encodeHexString((byte[])digest);
            webhookInvocation.getRequestBuilder().header(SIGNATURE_HEADER, algorithmDigestPrefix + digestString);
        }
        catch (InvalidKeyException e) {
            log.warn("Secret provided to webhook signature is invalid and will be ignored for invocation [{}]", (Object)webhookInvocation.getId());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Unable to initialize the signing algorithm [{}]. Webhooks will not be signed", (Object)algorithm);
        }
    }
}

