/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook;

import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.webhook.WebhookScopeAdapter;
import com.atlassian.event.api.EventListener;
import com.atlassian.webhooks.WebhookDeleteRequest;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.WebhookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookCleanupService {
    private static final Logger log = LoggerFactory.getLogger(WebhookCleanupService.class);
    private final WebhookService webhookService;

    public WebhookCleanupService(WebhookService webhookService) {
        this.webhookService = webhookService;
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            int deleted = this.webhookService.delete(((WebhookDeleteRequest.Builder)WebhookDeleteRequest.builder().scope(WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)event.getProject())), new WebhookScope[0])).build());
            log.debug("Deleted {} webhooks as part of cleanup from deleting project [{}]", (Object)deleted, (Object)event.getProject());
        }
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            int deleted = this.webhookService.delete(((WebhookDeleteRequest.Builder)WebhookDeleteRequest.builder().scope(WebhookScopeAdapter.adapt((Scope)Scopes.repository((Repository)event.getRepository())), new WebhookScope[0])).build());
            log.debug("Deleted {} webhooks as part of cleanup from deleting repository [{}]", (Object)deleted, (Object)event.getRepository());
        }
    }
}

