/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.audit;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookEvent;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize
public class JsonWebhook
extends RestMapEntity {
    private static final String ACTIVE = "active";
    private static final String CONFIGURATION = "configuration";
    private static final String CREATED_DATE = "createdDate";
    private static final String EVENTS = "events";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String SCOPE_TYPE = "scopeType";
    private static final String UPDATED_DATE = "updatedDate";
    private static final String URL = "url";

    public JsonWebhook() {
    }

    public JsonWebhook(Webhook webhook) {
        if (webhook.getId() > 0) {
            this.put(ID, webhook.getId());
        }
        this.put(NAME, webhook.getName());
        this.put(CREATED_DATE, webhook.getCreatedDate());
        this.put(UPDATED_DATE, webhook.getUpdatedDate());
        this.put(EVENTS, webhook.getEvents().stream().map(WebhookEvent::getId).collect(MoreCollectors.toImmutableSet()));
        this.put(CONFIGURATION, webhook.getConfiguration());
        this.put(URL, webhook.getUrl());
        this.put(ACTIVE, webhook.isActive());
        this.put(SCOPE_TYPE, webhook.getScope().getType());
    }
}

