/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.audit;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.internal.webhook.event.AbstractInternalWebhookEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalWebhookModifiedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class WebhookEventConverter
implements AuditEventConverter<AbstractInternalWebhookEvent> {
    @VisibleForTesting
    static final String ATTR_EVENTS = "bitbucket.webhooks.audit.attribute.webhook.events";
    @VisibleForTesting
    static final String KEY_ACTIVE = "bitbucket.webhooks.audit.changedvalue.webhook.active";
    @VisibleForTesting
    static final String KEY_NAME = "bitbucket.webhooks.audit.changedvalue.webhook.name";
    @VisibleForTesting
    static final String KEY_SCOPE = "bitbucket.webhooks.audit.attribute.webhook.scope";
    @VisibleForTesting
    static final String KEY_URL = "bitbucket.webhooks.audit.changedvalue.webhook.url";

    @Nonnull
    public AuditEvent convert(@Nonnull AbstractInternalWebhookEvent event, final @Nonnull AuditEvent.Builder builder) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(builder, "builder");
        event.getScope().accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                builder.affectedObject(AuditUtils.auditResourceForProject((Project)scope.getProject()));
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                builder.affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)scope.getRepository()));
                return null;
            }
        });
        Webhook webhook = event.getValue();
        Set events = webhook.getEvents();
        if (!events.isEmpty()) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_EVENTS, (String)events.stream().map(WebhookEvent::getId).map(String::toLowerCase).sorted().collect(Collectors.joining(", "))).build());
        }
        if (event instanceof InternalWebhookModifiedEvent) {
            InternalWebhookModifiedEvent e = (InternalWebhookModifiedEvent)((Object)event);
            Webhook oldHook = e.getOldValue();
            Webhook newHook = e.getNewValue();
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_ACTIVE).from(String.valueOf(oldHook.isActive())).to(String.valueOf(newHook.isActive())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_NAME).from(oldHook.getName()).to(newHook.getName()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_URL).from(oldHook.getUrl()).to(newHook.getUrl()).build());
            if (oldHook.getName().equals(newHook.getName())) {
                builder.extraAttribute(AuditAttribute.fromI18nKeys((String)KEY_NAME, (String)newHook.getName()).build());
            }
            if (oldHook.getUrl().equals(newHook.getUrl())) {
                builder.extraAttribute(AuditAttribute.fromI18nKeys((String)KEY_URL, (String)newHook.getUrl()).build());
            }
        } else {
            builder.appendExtraAttributes((Collection)ImmutableList.of((Object)AuditAttribute.fromI18nKeys((String)KEY_NAME, (String)webhook.getName()).build(), (Object)AuditAttribute.fromI18nKeys((String)KEY_URL, (String)webhook.getUrl()).build()));
        }
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)KEY_SCOPE, (String)event.getScope().getType().name()).build());
        return builder.build();
    }
}

