/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.event;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.google.common.hash.Hashing;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class AbstractAnalyticsWebhookTestedEvent {
    private final Scope scope;
    private final String url;
    private final Integer responseCode;

    protected AbstractAnalyticsWebhookTestedEvent(@Nonnull Scope scope, @Nonnull String url) {
        this(scope, url, null);
    }

    protected AbstractAnalyticsWebhookTestedEvent(@Nonnull Scope scope, @Nonnull String url, @Nullable Integer responseCode) {
        this.scope = scope;
        this.url = UUID.nameUUIDFromBytes(Hashing.sha256().hashString((CharSequence)url, StandardCharsets.UTF_8).asBytes()).toString();
        this.responseCode = responseCode;
    }

    @Nonnull
    public Project getProject() {
        return (Project)this.scope.accept((ScopeVisitor)new ScopeVisitor<Project>(this){

            public Project visit(@Nonnull ProjectScope scope) {
                return scope.getProject();
            }

            public Project visit(@Nonnull RepositoryScope scope) {
                return scope.getProject();
            }
        });
    }

    @Nonnull
    public Repository getRepository() {
        return (Repository)this.scope.accept((ScopeVisitor)new ScopeVisitor<Repository>(this){

            public Repository visit(@Nonnull RepositoryScope scope) {
                return scope.getRepository();
            }
        });
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public Integer getResponseCode() {
        return this.responseCode;
    }
}

