/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.event;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.webhooks.Webhook;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@TransactionAware
public abstract class AbstractInternalWebhookEvent
extends ApplicationEvent {
    private final Scope scope;

    protected AbstractInternalWebhookEvent(@Nonnull Object source, @Nonnull Scope scope) {
        super(source);
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    @Nonnull
    public Map<String, Object> getAnalyticsWebhook(Webhook webhook) {
        HashMap<String, Object> analyticsWebhook = new HashMap<String, Object>();
        analyticsWebhook.put("id", webhook.getId());
        analyticsWebhook.put("active", webhook.isActive());
        analyticsWebhook.put("events", webhook.getEvents().stream().map(event -> event.getId()).collect(Collectors.toSet()));
        analyticsWebhook.put("scopeType", this.scope.getType().name());
        return analyticsWebhook;
    }

    public Project getProject() {
        return (Project)this.scope.accept((ScopeVisitor)new ScopeVisitor<Project>(this){

            public Project visit(@Nonnull ProjectScope scope) {
                return scope.getProject();
            }

            public Project visit(@Nonnull RepositoryScope scope) {
                return scope.getProject();
            }
        });
    }

    public Repository getRepository() {
        return (Repository)this.scope.accept((ScopeVisitor)new ScopeVisitor<Repository>(this){

            public Repository visit(@Nonnull RepositoryScope scope) {
                return scope.getRepository();
            }
        });
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Nonnull
    public abstract Webhook getValue();

    @Nonnull
    public abstract Map<String, Object> getWebhook();

    public void removeSecretFromConfiguration(Webhook webhook) {
        webhook.getConfiguration().remove("secret");
    }
}

