/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.annotation.InternalAuditable;
import com.atlassian.bitbucket.internal.webhook.audit.WebhookEventConverter;
import com.atlassian.bitbucket.internal.webhook.event.AbstractInternalWebhookEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalWebhookModifiedEvent;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.webhooks.Webhook;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;

@AsynchronousPreferred
@EventName(value="stash.webhook.modified")
@InternalAuditable(actionI18nKey="bitbucket.webhooks.audit.action.project.webhook.modified", categoryI18nKey="bitbucket.service.audit.category.projects", coverageArea=CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, coverageLevel=CoverageLevel.BASE, converter=WebhookEventConverter.class)
public class InternalProjectWebhookModifiedEvent
extends AbstractInternalWebhookEvent
implements InternalWebhookModifiedEvent {
    private final Webhook oldValue;
    private final Webhook newValue;

    public InternalProjectWebhookModifiedEvent(@Nonnull Object source, @Nonnull Scope scope, @Nonnull Webhook oldValue, @Nonnull Webhook newValue) {
        super(source, scope);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.removeSecretFromConfiguration(newValue);
        this.removeSecretFromConfiguration(oldValue);
    }

    @Override
    @Nonnull
    public Webhook getOldValue() {
        return this.oldValue;
    }

    @Override
    @Nonnull
    public Webhook getNewValue() {
        return this.newValue;
    }

    @Override
    @Nonnull
    public Webhook getValue() {
        return this.newValue;
    }

    @Override
    @Nonnull
    public Map<String, Object> getWebhook() {
        return new ImmutableMap.Builder().put((Object)"old", this.getAnalyticsWebhook(this.oldValue)).put((Object)"new", this.getAnalyticsWebhook(this.newValue)).build();
    }
}

