/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.annotation.InternalAuditable;
import com.atlassian.bitbucket.internal.webhook.audit.WebhookEventConverter;
import com.atlassian.bitbucket.internal.webhook.event.AbstractInternalWebhookEvent;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.webhooks.Webhook;
import jakarta.annotation.Nonnull;
import java.util.Map;

@AsynchronousPreferred
@EventName(value="stash.webhook.created")
@InternalAuditable(actionI18nKey="bitbucket.webhooks.audit.action.repository.webhook.created", categoryI18nKey="bitbucket.service.audit.category.repositories", coverageArea=CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, coverageLevel=CoverageLevel.BASE, converter=WebhookEventConverter.class)
public class InternalRepositoryWebhookCreatedEvent
extends AbstractInternalWebhookEvent {
    private final Webhook webhook;

    public InternalRepositoryWebhookCreatedEvent(@Nonnull Object source, @Nonnull Scope scope, @Nonnull Webhook webhook) {
        super(source, scope);
        this.webhook = webhook;
        this.removeSecretFromConfiguration(webhook);
    }

    @Override
    @Nonnull
    public Map<String, Object> getAnalyticsWebhook(Webhook webhook) {
        Map<String, Object> analyticsWebhook = super.getAnalyticsWebhook(webhook);
        analyticsWebhook.put("createdBy", webhook.getConfiguration().getOrDefault("createdBy", ""));
        return analyticsWebhook;
    }

    @Override
    @Nonnull
    public Webhook getValue() {
        return this.webhook;
    }

    @Override
    @Nonnull
    public Map<String, Object> getWebhook() {
        return this.getAnalyticsWebhook(this.webhook);
    }
}

