/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.json;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.webhooks.WebhookEvent;
import java.util.Objects;

abstract class AbstractJsonEvent
extends RestMapEntity {
    private static final String KEY_DATE = "date";
    private static final String KEY_EVENT_KEY = "eventKey";

    AbstractJsonEvent(ApplicationEvent event, WebhookEvent webhookEvent, DateFormatter dateFormatter) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(webhookEvent, "webhookEvent");
        Objects.requireNonNull(dateFormatter, "dateFormatter");
        this.put(KEY_EVENT_KEY, webhookEvent.getId());
        this.put(KEY_DATE, dateFormatter.formatDate(event.getDate(), DateFormatter.FormatType.TIMESTAMP));
    }
}

