/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.json;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentEvent;
import com.atlassian.bitbucket.internal.webhook.json.AbstractActorJsonEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonComment;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.webhooks.WebhookEvent;

class JsonCommitDiscussionEvent
extends AbstractActorJsonEvent {
    private static final String COMMIT_ID = "commit";
    private static final String DISCUSSION_KEY = "comment";
    private static final String PARENT_ID = "commentParentId";
    private static final String REPOSITORY_KEY = "repository";

    JsonCommitDiscussionEvent(CommitDiscussionCommentEvent event, WebhookEvent webhookEvent, DateFormatter dateFormatter) {
        super((ApplicationEvent)event, webhookEvent, dateFormatter);
        this.put(DISCUSSION_KEY, (Object)new JsonComment(event.getComment()));
        this.put(REPOSITORY_KEY, new RestRepository(event.getRepository()));
        this.put(COMMIT_ID, event.getDiscussion().getCommitId());
        if (event.getParent() != null) {
            this.put(PARENT_ID, event.getParent().getId());
        }
    }
}

