/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.json;

import com.atlassian.bitbucket.dmz.rest.v2.repository.RestRefChange;
import com.atlassian.bitbucket.dmz.rest.v2.server.RestSimpleMirrorServer;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.mirror.RepositoryMirrorSynchronizedEvent;
import com.atlassian.bitbucket.internal.webhook.ApplicationWebhookEvent;
import com.atlassian.bitbucket.internal.webhook.json.AbstractJsonEvent;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.util.RestNamedLink;
import com.atlassian.bitbucket.rest.v2.api.util.RestRelatedLinks;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.bitbucket.util.MoreCollectors;

class JsonMirrorRepositorySynchronizedEvent
extends AbstractJsonEvent {
    private static final String KEY_CHANGES = "changes";
    private static final String KEY_MIRROR_SERVER = "mirrorServer";
    private static final String KEY_REPOSITORY = "repository";
    private static final String KEY_SYNC_TYPE = "syncType";
    private static final String KEY_REF_LIMIT_EXCEEDED = "refLimitExceeded";

    JsonMirrorRepositorySynchronizedEvent(RepositoryMirrorSynchronizedEvent event, DateFormatter dateFormatter) {
        super((ApplicationEvent)event, ApplicationWebhookEvent.MIRROR_REPOSITORY_SYNCHRONIZED, dateFormatter);
        RestRelatedLinks.Builder linkBuilder = new RestRelatedLinks.Builder();
        event.getCloneLinks().stream().map(RestNamedLink.REST_TRANSFORM).forEach(link -> linkBuilder.addRelatedLink("mirrorClone", link));
        RestRepository repository = new RestRepository(event.getRepository(), true);
        repository.setLinks(linkBuilder.build());
        this.put(KEY_MIRROR_SERVER, new RestSimpleMirrorServer(event.getMirrorServerId(), event.getMirrorServerName()));
        this.put(KEY_SYNC_TYPE, event.getSyncType());
        this.put(KEY_REPOSITORY, repository);
        this.put(KEY_CHANGES, event.getRefChanges().stream().map(RestRefChange::new).filter(this::isNotPullRequestRef).collect(MoreCollectors.toImmutableList()));
        this.put(KEY_REF_LIMIT_EXCEEDED, event.isRefLimitExceeded());
    }

    private boolean isNotPullRequestRef(RestRefChange ref) {
        String refId = (String)ref.get((Object)"refId");
        return !refId.startsWith("refs/heads/refs/pull-requests/") && !refId.startsWith("refs/pull-requests/");
    }
}

