/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.json;

import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestEvent;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.webhooks.WebhookEvent;
import java.util.Set;
import java.util.stream.Collectors;

class JsonPullRequestReviewersUpdated
extends JsonPullRequestEvent {
    public JsonPullRequestReviewersUpdated(PullRequestReviewersUpdatedEvent payload, WebhookEvent event, DateFormatter dateFormatter) {
        super((PullRequestEvent)payload, event, dateFormatter);
        Set<RestApplicationUser> removed = this.toRest(payload.getRemovedReviewers());
        Set<RestApplicationUser> added = this.toRest(payload.getAddedReviewers());
        this.put("addedReviewers", added);
        this.put("removedReviewers", removed);
    }

    private Set<RestApplicationUser> toRest(Set<ApplicationUser> reviewers) {
        return reviewers.stream().map(x -> new RestApplicationUser(x)).collect(Collectors.toSet());
    }
}

