/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.json;

import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestEvent;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRef;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.webhooks.WebhookEvent;
import org.apache.commons.lang3.StringUtils;

class JsonPullRequestUpdatedEvent
extends JsonPullRequestEvent {
    private static final int MAX_DESCRIPTION_LENGTH = 1000;

    public JsonPullRequestUpdatedEvent(PullRequestUpdatedEvent payload, WebhookEvent event, DateFormatter dateFormatter) {
        super((PullRequestEvent)payload, event, dateFormatter);
        this.put("previousTitle", payload.getPreviousTitle());
        this.put("previousDescription", StringUtils.truncate((String)payload.getPreviousDescription(), (int)1000));
        this.put("previousDraft", payload.isPreviousDraft());
        this.put("previousTarget", this.getToRef(payload));
    }

    private Object getToRef(PullRequestUpdatedEvent payload) {
        return payload.getPreviousToBranch() == null ? new RestRef((Ref)payload.getPullRequest().getToRef()) : new RestRef(payload.getPreviousToBranch());
    }
}

