/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.json;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestRefChange;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.internal.webhook.ApplicationWebhookEvent;
import com.atlassian.bitbucket.internal.webhook.event.InternalRepositoryWebhookRefsChangedEvent;
import com.atlassian.bitbucket.internal.webhook.json.AbstractJsonEvent;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.ImmutableList;
import java.util.List;

class JsonRepositoryRefsChangedEvent
extends AbstractJsonEvent {
    private static final String KEY_ACTOR = "actor";
    private static final String KEY_CHANGES = "changes";
    private static final String KEY_COMMITS = "commits";
    private static final String KEY_REPOSITORY = "repository";
    private static final String KEY_TO_COMMIT = "toCommit";

    JsonRepositoryRefsChangedEvent(RepositoryRefsChangedEvent event, DateFormatter dateFormatter) {
        super((ApplicationEvent)event, ApplicationWebhookEvent.REPOSITORY_REFS_CHANGED, dateFormatter);
        this.putIfNotNull(KEY_ACTOR, this.getUser(event));
        this.put(KEY_REPOSITORY, new RestRepository(event.getRepository(), true));
        this.put(KEY_CHANGES, event.getRefChanges().stream().map(RestRefChange::new).collect(MoreCollectors.toImmutableList()));
        this.putIfNotEmpty(KEY_COMMITS, this.getCommits(event));
        this.putIfNotNull(KEY_TO_COMMIT, this.getToCommit(event));
    }

    private List<RestCommit> getCommits(RepositoryRefsChangedEvent event) {
        ImmutableList commits = event instanceof InternalRepositoryWebhookRefsChangedEvent ? ImmutableList.copyOf(((InternalRepositoryWebhookRefsChangedEvent)event).getCommits()) : ImmutableList.of();
        return (List)commits.stream().map(RestCommit::new).collect(MoreCollectors.toImmutableList());
    }

    private RestCommit getToCommit(RepositoryRefsChangedEvent event) {
        Commit commit = event instanceof InternalRepositoryWebhookRefsChangedEvent ? ((InternalRepositoryWebhookRefsChangedEvent)event).getToCommit() : null;
        return commit == null ? null : new RestCommit(commit);
    }

    private ApplicationUser getUser(RepositoryRefsChangedEvent event) {
        ApplicationUser user = event instanceof InternalRepositoryWebhookRefsChangedEvent ? ((InternalRepositoryWebhookRefsChangedEvent)event).getSetUser() : event.getUser();
        return user == null ? null : new RestApplicationUser(user);
    }
}

