/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.json;

import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretLocation;
import com.atlassian.bitbucket.dmz.secretscanning.event.SecretsDetectedEvent;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.internal.webhook.ApplicationWebhookEvent;
import com.atlassian.bitbucket.internal.webhook.json.AbstractJsonEvent;
import com.atlassian.bitbucket.util.DateFormatter;
import java.util.stream.Collectors;

class JsonRepositorySecretDetectedEvent
extends AbstractJsonEvent {
    private static final String KEY_ACTOR = "actor";
    private static final String KEY_SECRET_LOCATIONS = "secretLocations";

    JsonRepositorySecretDetectedEvent(SecretsDetectedEvent event, DateFormatter dateFormatter) {
        super((ApplicationEvent)event, ApplicationWebhookEvent.REPOSITORY_SECRET_DETECTED, dateFormatter);
        this.put(KEY_ACTOR, event.getInitiatingUser());
        this.put(KEY_SECRET_LOCATIONS, event.getSecretLocations().stream().map(location -> new RestSecretLocation(location.getRepository(), location.getCommitId(), location.getLine(), location.getPath(), location.getRuleName())).collect(Collectors.toList()));
    }
}

