/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.webhook.json;

import com.atlassian.bitbucket.dmz.secretscanning.event.SecretsDetectedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentEditedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentEvent;
import com.atlassian.bitbucket.event.mirror.RepositoryMirrorSynchronizedEvent;
import com.atlassian.bitbucket.event.project.ProjectEvent;
import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentEditedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentEvent;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantStatusUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDefaultBranchModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.internal.webhook.ApplicationWebhookEvent;
import com.atlassian.bitbucket.internal.webhook.json.AbstractJsonEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonCommitDiscussionCommentEditedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonCommitDiscussionEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonMirrorRepositorySynchronizedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonProjectEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonProjectModifiedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestCommentEditedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestCommentEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestFromRefUpdatedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestMergedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestParticipantEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestReviewersUpdated;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestToRefUpdatedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonPullRequestUpdatedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonRepositoryDefaultBranchModifiedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonRepositoryEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonRepositoryModifiedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonRepositoryRefsChangedEvent;
import com.atlassian.bitbucket.internal.webhook.json.JsonRepositorySecretDetectedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.enrich.LinkEnricher;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.webhooks.WebhookEvent;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookJsonRenderer {
    private static final Logger log = LoggerFactory.getLogger(WebhookJsonRenderer.class);
    private final DateFormatter dateFormatter;
    private final JsonFactory jsonFactory;
    private final LinkEnricher linkEnricher;
    private final SecurityService securityService;

    public WebhookJsonRenderer(DateFormatter dateFormatter, LinkEnricher linkEnricher, SecurityService securityService) {
        this.dateFormatter = dateFormatter;
        this.linkEnricher = linkEnricher;
        this.securityService = securityService;
        this.jsonFactory = new ObjectMapper().getJsonFactory();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String render(ApplicationWebhookEvent event, Object payload) {
        AbstractJsonEvent jsonEvent = this.toJsonEvent(event, payload);
        if (jsonEvent == null) {
            return null;
        }
        this.enrichJsonEvent(jsonEvent);
        try (StringWriter writer = new StringWriter();){
            String string;
            block14: {
                JsonGenerator generator = this.jsonFactory.createJsonGenerator((Writer)writer);
                try {
                    generator.writeObject((Object)jsonEvent);
                    generator.flush();
                    string = writer.toString();
                    if (generator == null) break block14;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return string;
        }
        catch (IOException e) {
            log.warn("Unexpected exception while rendering an event object to a JSON string", (Throwable)e);
            return null;
        }
    }

    private void enrichJsonEvent(AbstractJsonEvent jsonEvent) {
        this.securityService.withPermission(Permission.REPO_READ, "Enriching webhook payload with links").call(() -> {
            this.linkEnricher.enrich((Object)jsonEvent);
            return null;
        });
    }

    private AbstractJsonEvent toJsonEvent(ApplicationWebhookEvent event, Object payload) {
        if (payload == null) {
            return null;
        }
        try {
            switch (event) {
                case PR_DECLINED: 
                case PR_DELETED: 
                case PR_OPENED: {
                    return new JsonPullRequestEvent((PullRequestEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case PR_MERGED: {
                    return new JsonPullRequestMergedEvent((PullRequestMergedEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case PR_FROM_REF_UPDATED: {
                    return new JsonPullRequestFromRefUpdatedEvent((PullRequestRescopedEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case PR_TO_REF_UPDATED: {
                    return new JsonPullRequestToRefUpdatedEvent((PullRequestRescopedEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case PR_MODIFIED: {
                    return new JsonPullRequestUpdatedEvent((PullRequestUpdatedEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case PR_COMMENT_ADDED: 
                case PR_COMMENT_DELETED: {
                    return new JsonPullRequestCommentEvent((PullRequestCommentEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case PR_COMMENT_EDITED: {
                    return new JsonPullRequestCommentEditedEvent((PullRequestCommentEditedEvent)payload, this.dateFormatter);
                }
                case PR_REVIEWER_UPDATED: {
                    return new JsonPullRequestReviewersUpdated((PullRequestReviewersUpdatedEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case PR_REVIEWER_STATUS_APPROVED: 
                case PR_REVIEWER_STATUS_NEEDS_WORK: 
                case PR_REVIEWER_STATUS_UNAPPROVED: {
                    return new JsonPullRequestParticipantEvent((PullRequestParticipantStatusUpdatedEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case PROJECT_CREATED: 
                case PROJECT_DELETED: {
                    return new JsonProjectEvent((ProjectEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case PROJECT_MODIFIED: {
                    return new JsonProjectModifiedEvent((ProjectModifiedEvent)payload, this.dateFormatter);
                }
                case REPOSITORY_REFS_CHANGED: {
                    return new JsonRepositoryRefsChangedEvent((RepositoryRefsChangedEvent)payload, this.dateFormatter);
                }
                case REPOSITORY_CREATED: 
                case REPOSITORY_FORKED: 
                case REPOSITORY_DELETED: {
                    return new JsonRepositoryEvent((RepositoryEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case REPOSITORY_MODIFIED: {
                    return new JsonRepositoryModifiedEvent((RepositoryModifiedEvent)payload, this.dateFormatter);
                }
                case REPOSITORY_DEFAULT_BRANCH_MODIFIED: {
                    return new JsonRepositoryDefaultBranchModifiedEvent((RepositoryDefaultBranchModifiedEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case REPOSITORY_SECRET_DETECTED: {
                    return new JsonRepositorySecretDetectedEvent((SecretsDetectedEvent)payload, this.dateFormatter);
                }
                case REPOSITORY_COMMENT_ADDED: 
                case REPOSITORY_COMMENT_DELETED: {
                    return new JsonCommitDiscussionEvent((CommitDiscussionCommentEvent)payload, (WebhookEvent)event, this.dateFormatter);
                }
                case REPOSITORY_COMMENT_EDITED: {
                    return new JsonCommitDiscussionCommentEditedEvent((CommitDiscussionCommentEditedEvent)payload, this.dateFormatter);
                }
                case MIRROR_REPOSITORY_SYNCHRONIZED: {
                    return new JsonMirrorRepositorySynchronizedEvent((RepositoryMirrorSynchronizedEvent)payload, this.dateFormatter);
                }
            }
        }
        catch (ClassCastException e) {
            log.warn("Cannot map webhook payload of type {} for event {} to json. Returning empty payload.", (Object)payload.getClass().getName(), (Object)event.getId());
        }
        return null;
    }
}

