/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.webhook;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectSupplier;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.webhooks.WebhookScope;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WebhookScopeAdapter
implements WebhookScope {
    private final List<WebhookScope> inheritedWebhookScopes;
    private final Scope scope;

    private WebhookScopeAdapter(Scope scope, List<WebhookScope> inheritedWebhookScopes) {
        this.scope = scope;
        this.inheritedWebhookScopes = ImmutableList.copyOf(inheritedWebhookScopes);
    }

    @Nonnull
    public static WebhookScope adapt(@Nonnull Scope scope) {
        return (WebhookScope)Objects.requireNonNull(scope, "scope").accept((ScopeVisitor)new ScopeVisitor<WebhookScope>(){

            public WebhookScope visit(@Nonnull GlobalScope scope) {
                return WebhookScope.GLOBAL;
            }

            public WebhookScope visit(@Nonnull ProjectScope scope) {
                WebhookScope globalScope = WebhookScopeAdapter.adapt((Scope)Scopes.global());
                return new WebhookScopeAdapter((Scope)scope, (List<WebhookScope>)ImmutableList.of((Object)globalScope));
            }

            public WebhookScope visit(@Nonnull RepositoryScope scope) {
                WebhookScope globalScope = WebhookScopeAdapter.adapt((Scope)Scopes.global());
                WebhookScope projectScope = WebhookScopeAdapter.adapt((Scope)Scopes.project((Project)scope.getProject()));
                return new WebhookScopeAdapter((Scope)scope, (List<WebhookScope>)ImmutableList.of((Object)projectScope, (Object)globalScope));
            }
        });
    }

    @Nonnull
    public static Scope adapt(@Nonnull ProjectSupplier projectSupplier, @Nonnull RepositorySupplier repositorySupplier, @Nonnull WebhookScope webhookScope) {
        Objects.requireNonNull(webhookScope, "webhookScope");
        String scopeType = webhookScope.getType();
        String scopeId = webhookScope.getId().orElse(null);
        switch (scopeType) {
            case "repository": {
                int repositoryId = Integer.parseInt(Objects.requireNonNull(scopeId, "scopeId"));
                Repository repository = repositorySupplier.getById(repositoryId);
                if (repository == null) {
                    throw new IllegalArgumentException("Repository scope with non-existing repository (ID: " + repositoryId + ")");
                }
                return Scopes.repository((Repository)repository);
            }
            case "project": {
                int projectId = Integer.parseInt(Objects.requireNonNull(scopeId, "scopeId"));
                Project project = projectSupplier.getById(projectId);
                if (project == null) {
                    throw new IllegalArgumentException("Project scope with non-existing project (ID: " + projectId + ")");
                }
                return Scopes.project((Project)project);
            }
            case "global": {
                return Scopes.global();
            }
        }
        throw new IllegalArgumentException("Unexpected scope on webhook: " + scopeType);
    }

    @Nonnull
    public Optional<String> getId() {
        return this.scope.getResourceId().map(Object::toString);
    }

    @Nonnull
    public List<WebhookScope> getInheritedWebhookScopes() {
        return this.inheritedWebhookScopes;
    }

    @Nonnull
    public String getType() {
        return this.scope.getType().name().toLowerCase();
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }
}

