/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.label;

import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.label.LabelConstants;
import com.atlassian.bitbucket.internal.label.dao.LabelDao;
import com.atlassian.bitbucket.internal.label.dao.LabelMappingDao;
import com.atlassian.bitbucket.internal.label.dao.LabelableSearchCriteria;
import com.atlassian.bitbucket.internal.label.model.InternalLabel;
import com.atlassian.bitbucket.internal.label.model.InternalLabelMapping;
import com.atlassian.bitbucket.label.AlreadyLabeledException;
import com.atlassian.bitbucket.label.ApplyLabelException;
import com.atlassian.bitbucket.label.ApplyLabelRequest;
import com.atlassian.bitbucket.label.InvalidLabelException;
import com.atlassian.bitbucket.label.Label;
import com.atlassian.bitbucket.label.LabelExistsException;
import com.atlassian.bitbucket.label.LabelService;
import com.atlassian.bitbucket.label.Labelable;
import com.atlassian.bitbucket.label.LabelableSearchRequest;
import com.atlassian.bitbucket.label.LabelableVisitor;
import com.atlassian.bitbucket.label.NoSuchLabelException;
import com.atlassian.bitbucket.label.RemoveLabelRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.annotation.RewriteExceptions;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Transactional(readOnly=true)
@RewriteExceptions
public class DefaultLabelService
implements LabelService {
    private final I18nService i18nService;
    private final LabelDao labelDao;
    private final LabelMappingDao labelMappingDao;
    private final PermissionPredicateFactory permissionPredicateFactory;
    private final PermissionValidationService permissionValidationService;
    private final TransactionTemplate withNewTransaction;

    public DefaultLabelService(I18nService i18nService, LabelDao labelDao, LabelMappingDao labelMappingDao, PermissionPredicateFactory permissionPredicateFactory, PermissionValidationService permissionValidationService, PlatformTransactionManager transactionManager) {
        this.i18nService = i18nService;
        this.labelDao = labelDao;
        this.labelMappingDao = labelMappingDao;
        this.permissionPredicateFactory = permissionPredicateFactory;
        this.permissionValidationService = permissionValidationService;
        this.withNewTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Nonnull
    @Transactional
    public Label apply(@Nonnull ApplyLabelRequest request) {
        this.validatePermission(request.getLabelable(), true);
        this.validateAddLabel(request);
        InternalLabel label = (InternalLabel)request.getLabel();
        if (this.labelMappingDao.find(request.getLabelable(), label).isPresent()) {
            throw new AlreadyLabeledException(this.i18nService.createKeyedMessage("bitbucket.label.error.label.already.added.to.entity", new Object[]{request.getLabel().getName()}), request.getLabel(), request.getLabelable());
        }
        InternalLabelMapping mapping = new InternalLabelMapping.Builder(request.getLabelable(), label).build();
        this.labelMappingDao.create(mapping);
        return label;
    }

    @Nonnull
    @Transactional
    public Label create(@Nonnull String labelName) {
        Objects.requireNonNull(labelName, "labelName");
        this.permissionValidationService.validateAuthenticated();
        this.validateLabelName(labelName);
        InternalLabel label = new InternalLabel.Builder(labelName).build();
        return (Label)this.labelDao.create(label);
    }

    @Nonnull
    public Page<Label> findAll(@Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.permissionValidationService.validateAuthenticated();
        return PageUtils.asPageOf(Label.class, (Page)this.labelDao.findAll(pageRequest));
    }

    @Nonnull
    public Page<Label> findByLabelable(@Nonnull Labelable labelable, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(labelable, "labelable");
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.validatePermission(labelable, false);
        return PageUtils.asPageOf(Label.class, this.labelDao.findByLabelable(labelable, pageRequest));
    }

    @Nonnull
    public Optional<Label> findByName(@Nonnull String labelName) {
        Objects.requireNonNull(labelName, "labelName");
        this.permissionValidationService.validateAuthenticated();
        return this.labelDao.findByName(labelName).map(Label.class::cast);
    }

    @Nonnull
    public Page<Label> findByPrefix(@Nonnull String labelPrefix, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(labelPrefix, "labelPrefix");
        Objects.requireNonNull(pageRequest, "pageRequest");
        this.permissionValidationService.validateAuthenticated();
        return PageUtils.asPageOf(Label.class, this.labelDao.search(labelPrefix, pageRequest));
    }

    @Nonnull
    public Label getByName(@Nonnull String labelName) {
        return this.findByName(labelName).orElseThrow(() -> this.noSuchLabelException(labelName));
    }

    @Nonnull
    public Page<Labelable> searchLabelables(@Nonnull LabelableSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Class filterClass = searchRequest.getType().map(type -> InternalRepository.class).orElse(null);
        LabelableSearchCriteria criteria = new LabelableSearchCriteria.Builder((InternalLabel)searchRequest.getLabel()).filterClass(filterClass).build();
        return this.labelMappingDao.searchLabelables(criteria, pageRequest, this.getLabelableVisiblePredicate());
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.withNewTransaction.execute(status -> {
            this.labelMappingDao.deleteByLabelable((Labelable)event.getRepository());
            this.labelDao.deleteOrphanedLabels();
            return null;
        });
    }

    @Transactional
    public void remove(@Nonnull RemoveLabelRequest request) {
        Objects.requireNonNull(request, "labelToEntityRequest");
        this.validatePermission(request.getLabelable(), true);
        InternalLabel label = (InternalLabel)request.getLabel();
        this.labelMappingDao.find(request.getLabelable(), label).ifPresent(entity -> {
            this.labelMappingDao.delete(entity);
            this.labelDao.deleteOrphanedLabels();
        });
    }

    private NoSuchLabelException noSuchLabelException(@Nonnull String labelName) {
        return new NoSuchLabelException(this.i18nService.createKeyedMessage("bitbucket.label.error.label.not.found", new Object[]{labelName}), labelName);
    }

    private Predicate<Labelable> getLabelableVisiblePredicate() {
        return new Predicate<Labelable>(){

            @Override
            public boolean test(Labelable labelable) {
                return (Boolean)labelable.accept((LabelableVisitor)new LabelableVisitor<Boolean>(){

                    public Boolean visit(@Nonnull Repository repository) {
                        return DefaultLabelService.this.permissionPredicateFactory.createRepositoryAccessiblePredicate().test(repository);
                    }
                });
            }
        };
    }

    private void validateAddLabel(ApplyLabelRequest request) {
        if (this.labelDao.countByLabelable(request.getLabelable()) >= 5L) {
            throw new ApplyLabelException(this.i18nService.createKeyedMessage("bitbucket.label.error.label.max.amount", new Object[]{5}));
        }
    }

    private void validateLabelName(String labelName) {
        Optional<InternalLabel> labelOptional = this.labelDao.findByName(labelName);
        if (labelOptional.isPresent()) {
            throw new LabelExistsException(this.i18nService.createKeyedMessage("bitbucket.label.error.label.exists", new Object[]{labelName}), (Label)labelOptional.get());
        }
        if (StringUtils.isBlank((CharSequence)labelName)) {
            throw new InvalidLabelException(this.i18nService.createKeyedMessage("bitbucket.label.error.label.empty", new Object[0]), labelName);
        }
        if (labelName.length() > 50) {
            throw new InvalidLabelException(this.i18nService.createKeyedMessage("bitbucket.label.error.label.too.long", new Object[]{50, labelName}), labelName);
        }
        if (labelName.length() < 3) {
            throw new InvalidLabelException(this.i18nService.createKeyedMessage("bitbucket.label.error.label.too.short", new Object[]{3, labelName}), labelName);
        }
        if (!labelName.equals(labelName.toLowerCase())) {
            throw new InvalidLabelException(this.i18nService.createKeyedMessage("bitbucket.label.error.label.contains.capitals", new Object[]{labelName}), labelName);
        }
        if (!LabelConstants.LABEL_PATTERN.matcher(labelName).matches()) {
            throw new InvalidLabelException(this.i18nService.createKeyedMessage("bitbucket.label.error.label.invalid.chars", new Object[]{labelName}), labelName);
        }
    }

    private void validatePermission(Labelable labelable, final boolean forEdit) {
        labelable.accept((LabelableVisitor)new LabelableVisitor<Void>(){

            public Void visit(@Nonnull Repository repository) {
                Permission permission = forEdit ? Permission.REPO_ADMIN : Permission.REPO_READ;
                DefaultLabelService.this.permissionValidationService.validateForRepository(repository, permission);
                return null;
            }
        });
    }
}

