/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.label.dao;

import com.atlassian.bitbucket.internal.label.dao.LabelDao;
import com.atlassian.bitbucket.internal.label.model.InternalLabel;
import com.atlassian.bitbucket.label.Labelable;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public class HibernateLabelDao
extends AbstractHibernateDao<Long, InternalLabel>
implements LabelDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = ImmutableList.of((Object)HqlQueryBuilder.HqlQueryOrder.asc((String)"name"));

    public HibernateLabelDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public long countByLabelable(@Nonnull Labelable labelable) {
        String hql = "SELECT count(m) FROM InternalLabelMapping m WHERE m.labelable = :labelable ";
        return (Long)this.session().createQuery(hql, Long.class).setParameter("labelable", (Object)labelable).uniqueResult();
    }

    @Override
    public int deleteOrphanedLabels() {
        return this.session().createQuery("DELETE FROM InternalLabel l WHERE (SELECT count(*) FROM InternalLabelMapping m WHERE m.label = l.id) = 0").executeUpdate();
    }

    @Override
    @Nonnull
    public Optional<InternalLabel> findByName(@Nonnull String labelName) {
        return this.session().createQuery("FROM InternalLabel WHERE name = :name", InternalLabel.class).setParameter("name", (Object)labelName).uniqueResultOptional();
    }

    @Override
    @Nonnull
    public Page<InternalLabel> findByLabelable(@Nonnull Labelable labelable, @Nonnull PageRequest pageRequest) {
        String hql = "SELECT label FROM InternalLabelMapping m WHERE m.labelable = :labelable ORDER BY name ASC";
        Query query = this.session().createQuery(hql, InternalLabel.class).setParameter("labelable", (Object)labelable);
        return this.pageQuery(query, pageRequest);
    }

    @Override
    @Nonnull
    public Page<InternalLabel> search(@Nonnull String namePrefix, @Nonnull PageRequest pageRequest) {
        String hql = "FROM InternalLabel WHERE name LIKE :prefix ORDER BY name ASC";
        Query query = this.session().createQuery(hql, InternalLabel.class).setParameter("prefix", (Object)(namePrefix + "%"));
        return this.pageQuery(query, pageRequest);
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

