/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.label.dao;

import com.atlassian.bitbucket.internal.label.dao.LabelMappingDao;
import com.atlassian.bitbucket.internal.label.dao.LabelableSearchCriteria;
import com.atlassian.bitbucket.internal.label.model.InternalLabel;
import com.atlassian.bitbucket.internal.label.model.InternalLabelMapping;
import com.atlassian.bitbucket.label.Labelable;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;

public class HibernateLabelMappingDao
extends AbstractHibernateDao<Long, InternalLabelMapping>
implements LabelMappingDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.desc((String)"id"));

    @Autowired
    public HibernateLabelMappingDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public void deleteByLabelable(@Nonnull Labelable labelable) {
        this.session().createQuery("DELETE from InternalLabelMapping mapping WHERE mapping.labelable = :labelable").setParameter("labelable", (Object)labelable).executeUpdate();
    }

    @Override
    @Nonnull
    public Optional<InternalLabelMapping> find(@Nonnull Labelable labelable, @Nonnull InternalLabel label) {
        String hql = "FROM InternalLabelMapping where label=:label and labelable=:labelable";
        return this.session().createQuery(hql, InternalLabelMapping.class).setParameter("label", (Object)label).setParameter("labelable", (Object)labelable).uniqueResultOptional();
    }

    @Override
    @Nonnull
    public Page<Labelable> searchLabelables(@Nonnull LabelableSearchCriteria criteria, @Nonnull PageRequest pageRequest, @Nonnull Predicate<Labelable> predicate) {
        String hql = "SELECT r FROM InternalLabelMapping m JOIN InternalRepository r ON m.labelable.id = r.id AND m.labelable.class = :repositoryClass WHERE m.label = :label ORDER BY r.project.name ASC, r.name ASC, r.id ASC";
        Query query = this.session().createQuery(hql, Labelable.class).setParameter("label", (Object)criteria.getLabel()).setParameter("repositoryClass", (Object)InternalRepository.class.getName());
        return HibernateUtils.initializePage((Page)HibernatePageUtils.pageQuery((Query)query, (PageRequest)pageRequest, predicate));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

