/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.label.dao;

import com.atlassian.bitbucket.internal.label.model.InternalLabel;
import com.atlassian.bitbucket.label.Labelable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class LabelableSearchCriteria {
    private final InternalLabel label;
    private final Class<? extends Labelable> filterClass;

    private LabelableSearchCriteria(Builder builder) {
        this.label = builder.label;
        this.filterClass = builder.filterClass;
    }

    @Nonnull
    public InternalLabel getLabel() {
        return this.label;
    }

    @Nullable
    public Class<? extends Labelable> getFilterClass() {
        return this.filterClass;
    }

    public static class Builder {
        private final InternalLabel label;
        private Class<? extends Labelable> filterClass;

        public Builder(@Nonnull InternalLabel value) {
            this.label = Objects.requireNonNull(value, "label");
        }

        @Nonnull
        public LabelableSearchCriteria build() {
            return new LabelableSearchCriteria(this);
        }

        @Nonnull
        public Builder filterClass(@Nullable Class<? extends Labelable> value) {
            this.filterClass = value;
            return this;
        }
    }
}

