/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.label.model;

import com.atlassian.bitbucket.label.Label;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Cacheable
@Entity
@Table(name="bb_label", uniqueConstraints={@UniqueConstraint(name="uk_label_name", columnNames={"name"})})
@TableGenerator(allocationSize=20, pkColumnValue="bb_label", name="labelIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalLabel
implements Label {
    public static final String ID_GEN = "labelIdGenerator";
    public static final String TABLE = "bb_label";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="labelIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="name", length=50, nullable=false, updatable=false)
    @RequiredString(size=50)
    private final String name;

    protected InternalLabel() {
        this.id = 0L;
        this.name = null;
    }

    private InternalLabel(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("name", (Object)this.getName()).toString();
    }

    public static class Builder
    extends BuilderSupport {
        private final long id;
        private final String name;

        public Builder(@Nonnull String name) {
            this.name = Builder.requireNonBlank((String)name, (String)"name");
            this.id = 0L;
        }

        @Nonnull
        public InternalLabel build() {
            return new InternalLabel(this);
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

