/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.label.model;

import com.atlassian.bitbucket.internal.label.model.InternalLabel;
import com.atlassian.bitbucket.label.Labelable;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.MetaValue;

@Cacheable
@Entity
@Table(name="bb_label_mapping", indexes={@Index(name="idx_bb_label_mapping_label_id", columnList="label_id"), @Index(name="idx_bb_label_map_labelable_id", columnList="labelable_id")}, uniqueConstraints={@UniqueConstraint(name="uq_label_mapping_ilt", columnNames={"label_id", " labelable_id", "labelable_type"})})
@TableGenerator(allocationSize=20, pkColumnValue="bb_label_mapping", name="labelMappingIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalLabelMapping {
    public static final String ID_GEN = "labelMappingIdGenerator";
    public static final String TABLE = "bb_label_mapping";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="labelMappingIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="labelable_type", nullable=false), optional=false)
    @AnyMetaDef(idType="integer", metaType="integer", metaValues={@MetaValue(targetEntity=InternalRepository.class, value="1")})
    @JoinColumn(name="labelable_id", nullable=false)
    private final Labelable labelable;
    @JoinColumn(name="label_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_label"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalLabel label;

    protected InternalLabelMapping() {
        this.id = 0L;
        this.labelable = null;
        this.label = null;
    }

    private InternalLabelMapping(Builder builder) {
        this.id = builder.id;
        this.label = builder.label;
        this.labelable = builder.labelable;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public InternalLabel getLabel() {
        return this.label;
    }

    @Nonnull
    public Labelable getLabelable() {
        return this.labelable;
    }

    public static class Builder {
        private final long id;
        private final Labelable labelable;
        private final InternalLabel label;

        public Builder(@Nonnull Labelable labelable, @Nonnull InternalLabel label) {
            this.label = Objects.requireNonNull(label, "label");
            this.labelable = Objects.requireNonNull(labelable, "labelable");
            this.id = 0L;
        }

        @Nonnull
        public InternalLabelMapping build() {
            return new InternalLabelMapping(this);
        }
    }
}

