/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.label.web;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.plugin.web.ContextProvider;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RepositoryLabelsDataContextProvider
implements ContextProvider {
    private final PermissionService permissionService;

    public RepositoryLabelsDataContextProvider(@Nonnull PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void init(@Nonnull Map<String, String> params) {
    }

    @Nonnull
    public Map<String, Object> getContextMap(@Nonnull Map<String, Object> context) {
        Objects.requireNonNull(context, "context");
        Repository repository = (Repository)context.get("repository");
        boolean hasRepositoryPermission = repository != null && this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN);
        HashMap<String, Object> contextMap = new HashMap<String, Object>(context);
        contextMap.put("isEditable", hasRepositoryPermission);
        return contextMap;
    }
}

