/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.label.web;

import com.atlassian.bitbucket.label.LabelService;
import com.atlassian.bitbucket.label.Labelable;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.web.Condition;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;

public class ShowLabelsCondition
implements Condition {
    private final LabelService labelService;
    private final PermissionService permissionService;

    public ShowLabelsCondition(@Nonnull LabelService labelService, @Nonnull PermissionService permissionService) {
        this.labelService = labelService;
        this.permissionService = permissionService;
    }

    public void init(Map<String, String> map) {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Repository repository = (Repository)Objects.requireNonNull(context, "context").get("repository");
        return repository != null && (this.isAdmin(repository) || this.hasLabels(repository));
    }

    private boolean hasLabels(Repository repository) {
        return this.permissionService.hasRepositoryPermission(repository, Permission.REPO_READ) && this.labelService.findByLabelable((Labelable)repository, PageUtils.newRequest((int)0, (int)1)).getSize() > 0;
    }

    private boolean isAdmin(Repository repository) {
        return this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN);
    }
}

